/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotatedClass;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoAnnotationVisitor;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoFieldVisitor;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MojoClassVisitor
extends ClassVisitor {
    private Logger logger;
    private MojoAnnotatedClass mojoAnnotatedClass;
    private Map<String, MojoAnnotationVisitor> annotationVisitorMap = new HashMap<String, MojoAnnotationVisitor>();
    private List<MojoFieldVisitor> fieldVisitors = new ArrayList<MojoFieldVisitor>();

    public MojoClassVisitor(Logger logger) {
        super(327680);
        this.logger = logger;
    }

    public MojoAnnotatedClass getMojoAnnotatedClass() {
        return this.mojoAnnotatedClass;
    }

    public void setMojoAnnotatedClass(MojoAnnotatedClass mojoAnnotatedClass) {
        this.mojoAnnotatedClass = mojoAnnotatedClass;
    }

    public Map<String, MojoAnnotationVisitor> getAnnotationVisitorMap() {
        return this.annotationVisitorMap;
    }

    public MojoAnnotationVisitor getAnnotationVisitor(Class<?> annotation) {
        return this.annotationVisitorMap.get(annotation.getName());
    }

    public void setAnnotationVisitorMap(Map<String, MojoAnnotationVisitor> annotationVisitorMap) {
        this.annotationVisitorMap = annotationVisitorMap;
    }

    public List<MojoFieldVisitor> getFieldVisitors() {
        return this.fieldVisitors;
    }

    public void setFieldVisitors(List<MojoFieldVisitor> fieldVisitors) {
        this.fieldVisitors = fieldVisitors;
    }

    public List<MojoFieldVisitor> findFieldWithAnnotation(Class<?> annotation) {
        String annotationClassName = annotation.getName();
        ArrayList<MojoFieldVisitor> mojoFieldVisitors = new ArrayList<MojoFieldVisitor>();
        for (MojoFieldVisitor mojoFieldVisitor : this.fieldVisitors) {
            MojoAnnotationVisitor mojoAnnotationVisitor = mojoFieldVisitor.getMojoAnnotationVisitor();
            if (mojoAnnotationVisitor == null || !StringUtils.equals((String)annotationClassName, (String)mojoAnnotationVisitor.getAnnotationClassName())) continue;
            mojoFieldVisitors.add(mojoFieldVisitor);
        }
        return mojoFieldVisitors;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.mojoAnnotatedClass = new MojoAnnotatedClass();
        this.mojoAnnotatedClass.setClassName(Type.getObjectType((String)name).getClassName());
        if (superName != null) {
            this.mojoAnnotatedClass.setParentClassName(Type.getObjectType((String)superName).getClassName());
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String annotationClassName = Type.getType((String)desc).getClassName();
        if (!MojoAnnotationsScanner.CLASS_LEVEL_ANNOTATIONS.contains(annotationClassName)) {
            return null;
        }
        MojoAnnotationVisitor mojoAnnotationVisitor = new MojoAnnotationVisitor(this.logger, annotationClassName);
        this.annotationVisitorMap.put(annotationClassName, mojoAnnotationVisitor);
        return mojoAnnotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        MojoFieldVisitor mojoFieldVisitor = new MojoFieldVisitor(this.logger, name, Type.getType((String)desc).getClassName());
        this.fieldVisitors.add(mojoFieldVisitor);
        return mojoFieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitEnd() {
    }
}

