/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.datamodel;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.AnnotatedField;

public class ParameterAnnotationContent
extends AnnotatedField
implements Parameter {
    private String name;
    private String alias;
    private String property;
    private String defaultValue;
    private boolean required = false;
    private boolean readonly = false;
    private String className;
    private boolean annotationOnMethod;
    private final List<String> typeParameters;

    public ParameterAnnotationContent(String fieldName, String className, List<String> typeParameters, boolean annotationOnMethod) {
        super(fieldName);
        this.className = className;
        this.typeParameters = typeParameters;
        this.annotationOnMethod = annotationOnMethod;
    }

    public ParameterAnnotationContent(String fieldName, String alias, String property, String defaultValue, boolean required, boolean readonly, String className, List<String> typeParameters, boolean annotationOnMethod) {
        this(fieldName, className, typeParameters, annotationOnMethod);
        this.alias = alias;
        this.property = property;
        this.defaultValue = defaultValue;
        this.required = required;
        this.readonly = readonly;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String alias() {
        return this.alias;
    }

    public void alias(String alias) {
        this.alias = alias;
    }

    public String property() {
        return this.property;
    }

    public void property(String property) {
        this.property = property;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public void defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean required() {
        return this.required;
    }

    public void required(boolean required) {
        this.required = required;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public void readonly(boolean readonly) {
        this.readonly = readonly;
    }

    public Class<? extends Annotation> annotationType() {
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<String> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean isAnnotationOnMethod() {
        return this.annotationOnMethod;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("ParameterAnnotationContent");
        sb.append("{fieldName='").append(this.getFieldName()).append('\'');
        sb.append(", className='").append(this.getClassName()).append('\'');
        sb.append(", typeParameters='").append(this.getTypeParameters()).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", alias='").append(this.alias).append('\'');
        sb.append(", alias='").append(this.alias).append('\'');
        sb.append(", property='").append(this.property).append('\'');
        sb.append(", defaultValue='").append(this.defaultValue).append('\'');
        sb.append(", required=").append(this.required);
        sb.append(", readonly=").append(this.readonly);
        sb.append(", methodSource=").append(this.annotationOnMethod);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterAnnotationContent)) {
            return false;
        }
        ParameterAnnotationContent that = (ParameterAnnotationContent)o;
        if (this.readonly != that.readonly) {
            return false;
        }
        if (this.required != that.required) {
            return false;
        }
        if (this.annotationOnMethod != that.annotationOnMethod) {
            return false;
        }
        if (this.getFieldName() != null ? !this.getFieldName().equals(that.getFieldName()) : that.getFieldName() != null) {
            return false;
        }
        if (this.getClassName() != null ? !this.getClassName().equals(that.getClassName()) : that.getClassName() != null) {
            return false;
        }
        if (!Objects.equals(this.typeParameters, that.typeParameters)) {
            return false;
        }
        if (!Objects.equals(this.alias, that.alias)) {
            return false;
        }
        if (!Objects.equals(this.defaultValue, that.defaultValue)) {
            return false;
        }
        return Objects.equals(this.property, that.property);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.getFieldName(), this.getClassName(), this.typeParameters, this.property, this.defaultValue, this.required, this.readonly, this.annotationOnMethod);
    }
}

