/*
 * $Id$
 */

package org.apache.maven.settings;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Proxy extends IdentifiableBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field active
     */
    private boolean active = false;

    /**
     * Field protocol
     */
    private String protocol = "http";

    /**
     * Field username
     */
    private String username;

    /**
     * Field password
     */
    private String password;

    /**
     * Field port
     */
    private int port = 8080;

    /**
     * Field host
     */
    private String host;

    /**
     * Field nonProxyHosts
     */
    private String nonProxyHosts;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get The proxy host.
     */
    public String getHost()
    {
        return this.host;
    } //-- String getHost() 

    /**
     * Get 
     *               The list of non-proxied hosts (delimited by
     * |).
     *           
     */
    public String getNonProxyHosts()
    {
        return this.nonProxyHosts;
    } //-- String getNonProxyHosts() 

    /**
     * Get The proxy password.
     */
    public String getPassword()
    {
        return this.password;
    } //-- String getPassword() 

    /**
     * Get The proxy port.
     */
    public int getPort()
    {
        return this.port;
    } //-- int getPort() 

    /**
     * Get The proxy protocol.
     */
    public String getProtocol()
    {
        return this.protocol;
    } //-- String getProtocol() 

    /**
     * Get The proxy user.
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername() 

    /**
     * Get Whether this proxy configuration is the active one.
     *           
     */
    public boolean isActive()
    {
        return this.active;
    } //-- boolean isActive() 

    /**
     * Set Whether this proxy configuration is the active one.
     *           
     * 
     * @param active
     */
    public void setActive(boolean active)
    {
        this.active = active;
    } //-- void setActive(boolean) 

    /**
     * Set The proxy host.
     * 
     * @param host
     */
    public void setHost(String host)
    {
        this.host = host;
    } //-- void setHost(String) 

    /**
     * Set 
     *               The list of non-proxied hosts (delimited by
     * |).
     *           
     * 
     * @param nonProxyHosts
     */
    public void setNonProxyHosts(String nonProxyHosts)
    {
        this.nonProxyHosts = nonProxyHosts;
    } //-- void setNonProxyHosts(String) 

    /**
     * Set The proxy password.
     * 
     * @param password
     */
    public void setPassword(String password)
    {
        this.password = password;
    } //-- void setPassword(String) 

    /**
     * Set The proxy port.
     * 
     * @param port
     */
    public void setPort(int port)
    {
        this.port = port;
    } //-- void setPort(int) 

    /**
     * Set The proxy protocol.
     * 
     * @param protocol
     */
    public void setProtocol(String protocol)
    {
        this.protocol = protocol;
    } //-- void setProtocol(String) 

    /**
     * Set The proxy user.
     * 
     * @param username
     */
    public void setUsername(String username)
    {
        this.username = username;
    } //-- void setUsername(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
