/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * This is the file specification used to activate the profile. The
 * missing value
 *         will be the location of a file that needs to exist, and
 * if it doesn't the profile will be
 *         activated. On the other hand exists will test for the
 * existence of the file and if it is
 *         there the profile will be activated.
 * 
 * @version $Revision$ $Date$
 */
public class ActivationFile implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The name of the file that must be missing to activate the
     *           profile.
     */
    private String missing;

    /**
     * The name of the file that must exist to activate the profile.
     */
    private String exists;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the name of the file that must exist to activate the
     * profile.
     * 
     * @return String
     */
    public String getExists()
    {
        return this.exists;
    } //-- String getExists() 

    /**
     * Get the name of the file that must be missing to activate
     * the
     *           profile.
     * 
     * @return String
     */
    public String getMissing()
    {
        return this.missing;
    } //-- String getMissing() 

    /**
     * Set the name of the file that must exist to activate the
     * profile.
     * 
     * @param exists
     */
    public void setExists( String exists )
    {
        this.exists = exists;
    } //-- void setExists( String ) 

    /**
     * Set the name of the file that must be missing to activate
     * the
     *           profile.
     * 
     * @param missing
     */
    public void setMissing( String missing )
    {
        this.missing = missing;
    } //-- void setMissing( String ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
