/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.repository.internal.MavenMetadata;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.metadata.Metadata;

final class VersionsMetadata
extends MavenMetadata {
    private final Artifact artifact;

    public VersionsMetadata(Artifact artifact) {
        super(VersionsMetadata.createMetadata(artifact), null);
        this.artifact = artifact;
    }

    public VersionsMetadata(Artifact artifact, File file) {
        super(VersionsMetadata.createMetadata(artifact), file);
        this.artifact = artifact;
    }

    private static Metadata createMetadata(Artifact artifact) {
        Versioning versioning = new Versioning();
        versioning.addVersion(artifact.getBaseVersion());
        if (!artifact.isSnapshot()) {
            versioning.setRelease(artifact.getVersion());
        }
        Metadata metadata = new Metadata();
        metadata.setModelVersion("1.0.0");
        metadata.setVersioning(versioning);
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        return metadata;
    }

    public Object getKey() {
        return this.getGroupId() + ':' + this.getArtifactId();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId();
    }

    public MavenMetadata setFile(File file) {
        return new VersionsMetadata(this.artifact, file);
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public String getVersion() {
        return "";
    }

    public Metadata.Nature getNature() {
        return this.artifact.isSnapshot() ? Metadata.Nature.RELEASE_OR_SNAPSHOT : Metadata.Nature.RELEASE;
    }
}

