/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.FeatureMapAndEpoch;

public interface Controller
extends AutoCloseable {
    public CompletableFuture<AlterIsrResponseData> alterIsr(AlterIsrRequestData var1);

    public CompletableFuture<CreateTopicsResponseData> createTopics(CreateTopicsRequestData var1);

    public CompletableFuture<Void> unregisterBroker(int var1);

    public CompletableFuture<Map<String, ResultOrError<Uuid>>> findTopicIds(long var1, Collection<String> var3);

    public CompletableFuture<Map<Uuid, ResultOrError<String>>> findTopicNames(long var1, Collection<Uuid> var3);

    public CompletableFuture<Map<Uuid, ApiError>> deleteTopics(long var1, Collection<Uuid> var3);

    public CompletableFuture<Map<ConfigResource, ResultOrError<Map<String, String>>>> describeConfigs(Map<ConfigResource, Collection<String>> var1);

    public CompletableFuture<ElectLeadersResponseData> electLeaders(ElectLeadersRequestData var1);

    public CompletableFuture<FeatureMapAndEpoch> finalizedFeatures();

    public CompletableFuture<Map<ConfigResource, ApiError>> incrementalAlterConfigs(Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> var1, boolean var2);

    public CompletableFuture<AlterPartitionReassignmentsResponseData> alterPartitionReassignments(AlterPartitionReassignmentsRequestData var1);

    public CompletableFuture<ListPartitionReassignmentsResponseData> listPartitionReassignments(ListPartitionReassignmentsRequestData var1);

    public CompletableFuture<Map<ConfigResource, ApiError>> legacyAlterConfigs(Map<ConfigResource, Map<String, String>> var1, boolean var2);

    public CompletableFuture<BrokerHeartbeatReply> processBrokerHeartbeat(BrokerHeartbeatRequestData var1);

    public CompletableFuture<BrokerRegistrationReply> registerBroker(BrokerRegistrationRequestData var1);

    public CompletableFuture<Void> waitForReadyBrokers(int var1);

    public CompletableFuture<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(Collection<ClientQuotaAlteration> var1, boolean var2);

    public CompletableFuture<AllocateProducerIdsResponseData> allocateProducerIds(AllocateProducerIdsRequestData var1);

    public CompletableFuture<Long> beginWritingSnapshot();

    public CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(long var1, List<CreatePartitionsRequestData.CreatePartitionsTopic> var3);

    public void beginShutdown();

    public int curClaimEpoch();

    default public boolean isActive() {
        return this.curClaimEpoch() != -1;
    }

    @Override
    public void close() throws InterruptedException;
}

