/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSetIpAddressProcessor<I extends TCLIService.Iface>
extends TCLIService.Processor<TCLIService.Iface> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ThriftHiveMetastore.Processor.class.getName());
    private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };

    public TSetIpAddressProcessor(TCLIService.Iface iface) {
        super(iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(TProtocol in, TProtocol out) throws TException {
        this.setIpAddress(in);
        this.setUserName(in);
        try {
            boolean bl = super.process(in, out);
            return bl;
        }
        finally {
            threadLocalUserName.remove();
            threadLocalIpAddress.remove();
        }
    }

    private void setUserName(TProtocol in) {
        TTransport transport = in.getTransport();
        if (transport instanceof TSaslServerTransport) {
            String userName = ((TSaslServerTransport)transport).getSaslServer().getAuthorizationID();
            threadLocalUserName.set(userName);
        }
    }

    protected void setIpAddress(TProtocol in) {
        TTransport transport = in.getTransport();
        TSocket tSocket = this.getUnderlyingSocketFromTransport(transport);
        if (tSocket != null) {
            threadLocalIpAddress.set(tSocket.getSocket().getInetAddress().toString());
        } else {
            LOGGER.warn("Unknown Transport, cannot determine ipAddress");
        }
    }

    private TSocket getUnderlyingSocketFromTransport(TTransport transport) {
        while (transport != null) {
            if (transport instanceof TSaslServerTransport) {
                transport = ((TSaslServerTransport)transport).getUnderlyingTransport();
            }
            if (transport instanceof TSaslClientTransport) {
                transport = ((TSaslClientTransport)transport).getUnderlyingTransport();
            }
            if (!(transport instanceof TSocket)) continue;
            return (TSocket)transport;
        }
        return null;
    }

    public static String getUserIpAddress() {
        return threadLocalIpAddress.get();
    }

    public static String getUserName() {
        return threadLocalUserName.get();
    }
}

