/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;

public class HttpCLIServiceUGIProcessor
implements TProcessor {
    private final TProcessor underlyingProcessor;
    private final HadoopShims shim;

    public HttpCLIServiceUGIProcessor(TProcessor underlyingProcessor) {
        this.underlyingProcessor = underlyingProcessor;
        this.shim = ShimLoader.getHadoopShims();
    }

    public boolean process(final TProtocol in, final TProtocol out) throws TException {
        UserGroupInformation clientUgi = null;
        try {
            clientUgi = this.shim.createRemoteUser(SessionManager.getUserName(), new ArrayList());
            return (Boolean)this.shim.doAs(clientUgi, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        return HttpCLIServiceUGIProcessor.this.underlyingProcessor.process(in, out);
                    }
                    catch (TException te) {
                        throw new RuntimeException(te);
                    }
                }
            });
        }
        catch (RuntimeException rte) {
            if (rte.getCause() instanceof TException) {
                throw (TException)rte.getCause();
            }
            throw rte;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

