/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import javax.jdo.JDOException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreInit;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RetryingHMSHandler
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(RetryingHMSHandler.class);
    private final IHMSHandler base;
    private final MetaStoreInit.MetaStoreInitData metaStoreInitData = new MetaStoreInit.MetaStoreInitData();
    private final HiveConf hiveConf;

    protected RetryingHMSHandler(HiveConf hiveConf, String name) throws MetaException {
        this.hiveConf = hiveConf;
        this.init();
        this.base = new HiveMetaStore.HMSHandler(name, hiveConf);
    }

    public static IHMSHandler getProxy(HiveConf hiveConf, String name) throws MetaException {
        RetryingHMSHandler handler = new RetryingHMSHandler(hiveConf, name);
        return (IHMSHandler)Proxy.newProxyInstance(RetryingHMSHandler.class.getClassLoader(), new Class[]{IHMSHandler.class}, (InvocationHandler)handler);
    }

    private void init() throws MetaException {
        MetaStoreInit.updateConnectionURL(this.hiveConf, this.getConf(), null, this.metaStoreInitData);
    }

    private void initMS() {
        this.base.setConf(this.getConf());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        boolean gotNewConnectUrl = false;
        boolean reloadConf = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HMSHANDLERFORCERELOADCONF);
        int retryInterval = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HMSHANDLERINTERVAL);
        int retryLimit = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HMSHANDLERATTEMPTS);
        if (reloadConf) {
            MetaStoreInit.updateConnectionURL(this.hiveConf, this.getConf(), null, this.metaStoreInitData);
        }
        int retryCount = 0;
        Throwable caughtException = null;
        while (true) {
            try {
                if (reloadConf || gotNewConnectUrl) {
                    this.initMS();
                }
                ret = method.invoke((Object)this.base, args);
                break;
            }
            catch (JDOException e) {
                caughtException = e;
            }
            catch (UndeclaredThrowableException e) {
                if (e.getCause() != null) {
                    if (e.getCause() instanceof JDOException) {
                        caughtException = e.getCause();
                    }
                    if (e.getCause() instanceof MetaException && e.getCause().getCause() != null && e.getCause().getCause() instanceof JDOException) {
                        caughtException = e.getCause().getCause();
                    }
                    LOG.error((Object)ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                    throw e.getCause();
                }
                LOG.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof JDOException) {
                    caughtException = e.getCause();
                }
                if (e.getCause() instanceof NoSuchObjectException) {
                    String methodName = method.getName();
                    if (!methodName.startsWith("get_table") && !methodName.startsWith("get_partition")) {
                        LOG.error((Object)ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                    }
                    throw e.getCause();
                }
                if (e.getCause() instanceof MetaException && e.getCause().getCause() != null && e.getCause().getCause() instanceof JDOException) {
                    caughtException = e.getCause().getCause();
                }
                LOG.error((Object)ExceptionUtils.getStackTrace((Throwable)e.getCause()));
                throw e.getCause();
            }
            if (retryCount >= retryLimit) {
                LOG.error((Object)("HMSHandler Fatal error: " + ExceptionUtils.getStackTrace((Throwable)caughtException)));
                throw new MetaException(ExceptionUtils.getStackTrace((Throwable)caughtException));
            }
            assert (retryInterval >= 0);
            LOG.error((Object)(String.format("Retrying HMSHandler after %d ms (attempt %d of %d)", retryInterval, ++retryCount, retryLimit) + " with error: " + ExceptionUtils.getStackTrace((Throwable)caughtException)));
            Thread.sleep(retryInterval);
            String lastUrl = MetaStoreInit.getConnectionURL(this.getConf());
            gotNewConnectUrl = MetaStoreInit.updateConnectionURL(this.hiveConf, this.getConf(), lastUrl, this.metaStoreInitData);
        }
        return ret;
    }

    public Configuration getConf() {
        return this.hiveConf;
    }
}

