/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import java.io.IOException;
import java.text.ParseException;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.PrepareString;
import org.apache.directory.shared.ldap.util.GeneralizedTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizedTimeNormalizer
extends Normalizer {
    public static final long serialVersionUID = 1L;

    public GeneralizedTimeNormalizer() {
        super("2.5.13.27");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws NamingException {
        try {
            String normalized = PrepareString.normalize(value.getString(), PrepareString.StringType.DIRECTORY_STRING);
            return new ClientStringValue(normalized);
        }
        catch (IOException ioe) {
            throw new NamingException(I18n.err((String)"ERR_04224", (Object[])new Object[]{value}));
        }
    }

    @Override
    public String normalize(String value) throws NamingException {
        try {
            String prepared = PrepareString.normalize(value, PrepareString.StringType.DIRECTORY_STRING);
            GeneralizedTime time = new GeneralizedTime(prepared);
            String normalized = time.toGeneralizedTime(GeneralizedTime.Format.YEAR_MONTH_DAY_HOUR_MIN_SEC_FRACTION, GeneralizedTime.FractionDelimiter.DOT, 3, GeneralizedTime.TimeZoneFormat.Z);
            return normalized;
        }
        catch (IOException ioe) {
            throw new NamingException(I18n.err((String)"ERR_04224", (Object[])new Object[]{value}));
        }
        catch (ParseException pe) {
            throw new NamingException(I18n.err((String)"ERR_04224", (Object[])new Object[]{value}));
        }
    }
}

