/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.apache.directory.shared.ldap.util.StringTools;

public abstract class LoadableSchemaObject
extends AbstractSchemaObject {
    private static final long serialVersionUID = 1L;
    private String fqcn = "";
    private String bytecode = null;

    protected LoadableSchemaObject(SchemaObjectType objectType, String oid) {
        super(objectType, oid);
    }

    protected LoadableSchemaObject(SchemaObjectType objectType) {
        super(objectType);
    }

    public String getBytecode() {
        return this.bytecode;
    }

    public void setBytecode(String bytecode) {
        if (!this.isReadOnly) {
            this.bytecode = bytecode;
        }
    }

    public String getFqcn() {
        return this.fqcn;
    }

    public void setFqcn(String fqcn) {
        if (!this.isReadOnly) {
            this.fqcn = fqcn;
        }
    }

    public void registerOid(SchemaObject schemaObject, Registries registries) throws NamingException {
    }

    public LoadableSchemaObject copy() {
        return null;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LoadableSchemaObject)) {
            return false;
        }
        LoadableSchemaObject that = (LoadableSchemaObject)o;
        if (this.fqcn == null) {
            return that.fqcn == null;
        }
        return this.fqcn.equals(that.fqcn);
    }

    public boolean isValid() {
        String className = this.getClass().getName();
        if (StringTools.isEmpty(this.fqcn)) {
            this.fqcn = className;
            return true;
        }
        return className.equals(this.fqcn);
    }
}

