/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERObject;

public class DERApplicationSpecific
extends DERObject {
    private int tag;

    public DERApplicationSpecific(int tag, byte[] value) {
        super(tag, value);
        this.tag = tag;
    }

    public static DERApplicationSpecific valueOf(int tag, DEREncodable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        aos.writeObject(object);
        return new DERApplicationSpecific(tag |= 0x20, baos.toByteArray());
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DEREncodable getObject() throws IOException {
        ASN1InputStream ais = new ASN1InputStream(this.getOctets());
        try {
            DEREncodable dEREncodable = ais.readObject();
            return dEREncodable;
        }
        finally {
            ais.close();
        }
    }

    public void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(0x40 | this.tag, this.value);
    }
}

