/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.util.ArrayList;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class NamespaceTools {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String getRdnAttribute(String rdn) {
        int index = rdn.indexOf(61);
        return rdn.substring(0, index);
    }

    public static String getRdnValue(String rdn) {
        int index = rdn.indexOf(61);
        return rdn.substring(index + 1, rdn.length());
    }

    public static boolean isSibling(Name name1, Name name2) throws NamingException {
        if (name1.size() == name2.size()) {
            LdapDN parentDn = (LdapDN)name1.clone();
            parentDn.remove(name1.size() - 1);
            return name2.startsWith(parentDn);
        }
        return false;
    }

    public static boolean isDescendant(Name ancestor, Name descendant) {
        return descendant.startsWith(ancestor);
    }

    public static Name getRelativeName(Name ancestor, Name descendant) throws NamingException {
        LdapDN rdn = null;
        rdn = descendant instanceof LdapDN ? (LdapDN)descendant.clone() : new LdapDN(descendant.toString());
        if (rdn.startsWith(ancestor)) {
            for (int ii = 0; ii < ancestor.size(); ++ii) {
                rdn.remove(0);
            }
        } else {
            NamingException e = new NamingException(descendant + " is not ancestually related to context:" + ancestor);
            throw e;
        }
        return rdn;
    }

    public static String inferLdapName(String realm) {
        if (StringTools.isEmpty(realm)) {
            return "";
        }
        StringBuffer buf = new StringBuffer(realm.length());
        buf.append("dc=");
        int start = 0;
        int end = 0;
        while ((end = realm.indexOf(46, start)) != -1) {
            buf.append(realm.substring(start, end)).append(",dc=");
            start = end + 1;
        }
        buf.append(realm.substring(start));
        return buf.toString();
    }

    public static String[] getCompositeComponents(String compositeNameComponent) throws NamingException {
        int lastIndex = compositeNameComponent.length() - 1;
        ArrayList<String> comps = new ArrayList<String>();
        for (int ii = compositeNameComponent.length() - 1; ii >= 0; --ii) {
            if (compositeNameComponent.charAt(ii) == '+') {
                if (ii == 0) {
                    throw new NamingException("invalid name - a name cannot start with a '+': " + compositeNameComponent);
                }
                if (compositeNameComponent.charAt(ii - 1) != '\\') {
                    if (lastIndex == compositeNameComponent.length() - 1) {
                        comps.add(0, compositeNameComponent.substring(ii + 1, lastIndex + 1));
                    } else {
                        comps.add(0, compositeNameComponent.substring(ii + 1, lastIndex));
                    }
                    lastIndex = ii;
                }
            }
            if (ii != 0) continue;
            if (lastIndex == compositeNameComponent.length() - 1) {
                comps.add(0, compositeNameComponent);
            } else {
                comps.add(0, compositeNameComponent.substring(ii, lastIndex));
            }
            lastIndex = 0;
        }
        if (comps.size() == 0) {
            comps.add(compositeNameComponent);
        }
        return comps.toArray(EMPTY_STRING_ARRAY);
    }

    public static boolean hasCompositeComponents(String name) throws NamingException {
        for (int ii = name.length() - 1; ii >= 0; --ii) {
            if (name.charAt(ii) != '+') continue;
            if (ii == 0) {
                throw new NamingException("invalid name - a name cannot start with a '+': " + name);
            }
            if (name.charAt(ii - 1) == '\\') continue;
            return true;
        }
        return false;
    }
}

