/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncStateValue;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.message.control.replication.SyncStateTypeEnum;
import org.apache.directory.shared.ldap.util.StringTools;

public class SyncStateValueControlCodec
extends AbstractAsn1Object {
    private SyncStateTypeEnum syncStateType;
    private byte[] cookie;
    private byte[] entryUUID;
    private int syncStateValueLength;

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public SyncStateTypeEnum getSyncStateType() {
        return this.syncStateType;
    }

    public void setSyncStateType(SyncStateTypeEnum syncStateType) {
        this.syncStateType = syncStateType;
    }

    public byte[] getEntryUUID() {
        return this.entryUUID;
    }

    public void setEntryUUID(byte[] entryUUID) {
        this.entryUUID = entryUUID;
    }

    public int computeLength() {
        this.syncStateValueLength = 3;
        this.syncStateValueLength += 1 + TLV.getNbBytes(this.entryUUID.length) + this.entryUUID.length;
        if (this.cookie != null) {
            this.syncStateValueLength += 1 + TLV.getNbBytes(this.cookie.length) + this.cookie.length;
        }
        return 1 + TLV.getNbBytes(this.syncStateValueLength) + this.syncStateValueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(TLV.getBytes(this.syncStateValueLength));
        bb.put((byte)10);
        bb.put((byte)1);
        bb.put(Value.getBytes(this.syncStateType.getValue()));
        Value.encode(bb, this.entryUUID);
        if (this.cookie != null) {
            Value.encode(bb, this.cookie);
        }
        return bb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncStateValue control :\n");
        sb.append("        syncStateType     : '").append((Object)this.syncStateType).append("'\n");
        sb.append("        entryUUID         : '").append(StringTools.dumpBytes(this.entryUUID)).append("'\n");
        sb.append("        cookie            : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
        return sb.toString();
    }
}

