/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue.SyncRequestValueControlCodec;
import org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue.SyncRequestValueControlContainer;
import org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue.SyncRequestValueControlStatesEnum;
import org.apache.directory.shared.ldap.message.control.replication.SynchronizationModeEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRequestValueControlGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(SyncRequestValueControlGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static IGrammar instance = new SyncRequestValueControlGrammar();

    private SyncRequestValueControlGrammar() {
        this.name = SyncRequestValueControlGrammar.class.getName();
        this.statesEnum = SyncRequestValueControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[5][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, new GrammarAction("Init SyncRequestValueControl"){

            public void action(IAsn1Container container) {
                SyncRequestValueControlContainer SyncRequestValueContainer = (SyncRequestValueControlContainer)container;
                SyncRequestValueControlCodec control = new SyncRequestValueControlCodec();
                SyncRequestValueContainer.setSyncRequestValueControl(control);
            }
        });
        this.transitions[1][10] = new GrammarTransition(1, 2, 10, new GrammarAction("Set SyncRequestValueControl mode"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncRequestValueControlContainer SyncRequestValueContainer = (SyncRequestValueControlContainer)container;
                Value value = SyncRequestValueContainer.getCurrentTLV().getValue();
                try {
                    int mode = IntegerDecoder.parse(value, SynchronizationModeEnum.UNUSED.getValue(), SynchronizationModeEnum.REFRESH_AND_PERSIST.getValue());
                    SynchronizationModeEnum modeEnum = SynchronizationModeEnum.getSyncMode(mode);
                    if (IS_DEBUG) {
                        LOG.debug("Mode = " + (Object)((Object)modeEnum));
                    }
                    SyncRequestValueContainer.getSyncRequestValueControl().setMode(modeEnum);
                    SyncRequestValueContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the mode for SyncRequestValueControl";
                    LOG.error(msg, e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[2][4] = new GrammarTransition(2, 3, 4, new GrammarAction("Set SyncRequestValueControl cookie"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncRequestValueControlContainer SyncRequestValueContainer = (SyncRequestValueControlContainer)container;
                Value value = SyncRequestValueContainer.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = " + StringTools.dumpBytes(cookie));
                }
                SyncRequestValueContainer.getSyncRequestValueControl().setCookie(cookie);
                SyncRequestValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[2][1] = new GrammarTransition(2, 4, 1, new GrammarAction("Set SyncRequestValueControl reloadHint flag"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncRequestValueControlContainer SyncRequestValueContainer = (SyncRequestValueControlContainer)container;
                Value value = SyncRequestValueContainer.getCurrentTLV().getValue();
                try {
                    boolean reloadHint = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("reloadHint = " + reloadHint);
                    }
                    SyncRequestValueContainer.getSyncRequestValueControl().setReloadHint(reloadHint);
                    SyncRequestValueContainer.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException e) {
                    String msg = "failed to decode the reloadHint flag for SyncRequestValueControl";
                    LOG.error(msg, e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[3][1] = new GrammarTransition(3, 4, 1, new GrammarAction("Set SyncRequestValueControl reloadHint flag"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncRequestValueControlContainer SyncRequestValueContainer = (SyncRequestValueControlContainer)container;
                Value value = SyncRequestValueContainer.getCurrentTLV().getValue();
                try {
                    boolean reloadHint = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("reloadHint = " + reloadHint);
                    }
                    SyncRequestValueContainer.getSyncRequestValueControl().setReloadHint(reloadHint);
                    SyncRequestValueContainer.grammarEndAllowed(true);
                }
                catch (BooleanDecoderException e) {
                    String msg = "failed to decode the reloadHint flag for SyncRequestValueControl";
                    LOG.error(msg, e);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

