/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeValueException;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeClassLoader
extends ClassLoader {
    public ServerAttribute attribute;

    public AttributeClassLoader() {
        super(AttributeClassLoader.class.getClassLoader());
    }

    public void setAttribute(EntryAttribute attribute) throws NamingException {
        if (((ServerAttribute)attribute).getAttributeType().getSyntax().isHumanReadable()) {
            throw new InvalidAttributeValueException("The attribute must be binary");
        }
        this.attribute = (ServerAttribute)attribute;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = null;
        Value<?> value = this.attribute.get();
        if (value.isBinary()) {
            classBytes = value.getBytes();
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        throw new ClassNotFoundException("Failed to access attribute bytes.");
    }
}

