/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.jndi.DeadContext;
import org.apache.directory.server.core.jndi.JndiUtils;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreContextFactory
implements InitialContextFactory {
    public synchronized Context getInitialContext(Hashtable env) throws NamingException {
        env = (Hashtable)env.clone();
        LdapDN principalDn = new LdapDN(CoreContextFactory.getPrincipal(env));
        byte[] credential = CoreContextFactory.getCredential(env);
        String authentication = CoreContextFactory.getAuthentication(env);
        String providerUrl = CoreContextFactory.getProviderUrl(env);
        DirectoryService service = (DirectoryService)env.get(DirectoryService.JNDI_KEY);
        if (service == null) {
            throw new ConfigurationException("Cannot find directory service in environment: " + env);
        }
        if (!service.isStarted()) {
            return new DeadContext();
        }
        ServerContext ctx = null;
        try {
            CoreSession session = service.getSession(principalDn, credential);
            ctx = new ServerLdapContext(service, session, new LdapDN(providerUrl));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        ctx.lookup("");
        return ctx;
    }

    public static String getProviderUrl(Hashtable<String, Object> env) {
        Object value = env.get("java.naming.provider.url");
        if (value == null) {
            value = "";
        }
        String providerUrl = value.toString();
        env.put("java.naming.provider.url", providerUrl);
        return providerUrl;
    }

    public static String getAuthentication(Hashtable<String, Object> env) {
        Object value = env.get("java.naming.security.authentication");
        String authentication = value == null ? AuthenticationLevel.NONE.toString() : value.toString();
        env.put("java.naming.security.authentication", authentication);
        return authentication;
    }

    public static byte[] getCredential(Hashtable<String, Object> env) throws ConfigurationException {
        byte[] credential;
        Object value = env.get("java.naming.security.credentials");
        if (value == null) {
            credential = null;
        } else if (value instanceof String) {
            credential = StringTools.getBytesUtf8((String)value);
        } else if (value instanceof byte[]) {
            credential = (byte[])value;
        } else {
            throw new ConfigurationException("Can't convert 'java.naming.security.credentials' to byte[].");
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        return credential;
    }

    public static String getPrincipal(Hashtable<String, Object> env) {
        String principal;
        Object value = env.get("java.naming.security.principal");
        if (value == null) {
            principal = null;
        } else {
            principal = value.toString();
            env.put("java.naming.security.principal", principal);
        }
        return principal;
    }
}

