/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc.processor.address;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.misc.processor.address.Address;
import org.apache.cxf.tools.util.NameUtil;

public final class AddressFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(AddressFactory.class);
    private static final String PREFIX = "org.apache.cxf.tools.misc.processor.address";
    private static final AddressFactory INSTANCE = new AddressFactory();
    private final Map<String, Address> addresses = new HashMap<String, Address>();

    private AddressFactory() {
    }

    public static AddressFactory getInstance() {
        return INSTANCE;
    }

    public Address getAddresser(String name) {
        Address address = this.addresses.get(name);
        if (address != null) {
            return address;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX);
        sb.append(".");
        sb.append(NameUtil.capitalize((String)name));
        sb.append("Address");
        try {
            address = (Address)Class.forName(sb.toString()).newInstance();
            this.addresses.put(name, address);
            LOG.log(Level.FINE, "FOUND_ADDRESSER", sb);
            return address;
        }
        catch (Exception e) {
            Message msg = new Message("FOUND_NO_ADDRESSER", LOG, new Object[]{sb});
            throw new ToolException(msg);
        }
    }
}

