/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.authorization;

import java.security.Principal;
import java.util.List;
import org.apache.cxf.rs.security.saml.assertion.Claim;
import org.apache.cxf.rs.security.saml.assertion.Claims;
import org.apache.cxf.rs.security.saml.assertion.Subject;
import org.apache.cxf.rs.security.saml.authorization.SubjectPrincipal;
import org.apache.cxf.security.SecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLSecurityContext
implements SecurityContext {
    private SubjectPrincipal p;
    private Claims claims;
    private Claim rolesClaim;

    public SAMLSecurityContext(Subject subject, List<Claim> claims) {
        this(new SubjectPrincipal(subject.getName(), subject), new Claims(claims));
    }

    public SAMLSecurityContext(SubjectPrincipal p, Claims claims) {
        this(p, claims, "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role", "http://schemas.xmlsoap.org/ws/2005/05/identity/claims");
    }

    public SAMLSecurityContext(SubjectPrincipal p, Claims cs, String roleClaimNameQualifier, String roleClaimNameFormat) {
        this.p = p;
        for (Claim c : cs.getClaims()) {
            if (!c.getName().equals(roleClaimNameQualifier) || !c.getNameFormat().equals(roleClaimNameFormat)) continue;
            this.rolesClaim = c;
            break;
        }
        this.claims = cs;
    }

    public Principal getUserPrincipal() {
        return this.p;
    }

    public boolean isUserInRole(String role) {
        if (this.rolesClaim == null) {
            return false;
        }
        for (String r : this.rolesClaim.getValues()) {
            if (!r.equals(role)) continue;
            return true;
        }
        return false;
    }

    public Claims getClaims() {
        return this.claims;
    }
}

