/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.ext.logging.LoggingFeature;

public class LoggingBusLifecycleListener
implements BusLifeCycleListener {
    static final boolean FORCE_LOGGING;
    static final boolean FORCE_PRETTY;
    private final Bus bus;

    public LoggingBusLifecycleListener(Bus b) {
        this.bus = b;
        ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
    }

    public void initComplete() {
        if (FORCE_LOGGING) {
            LoggingFeature feature = new LoggingFeature();
            feature.setPrettyLogging(FORCE_PRETTY);
            this.bus.getFeatures().add(feature);
            feature.initialize(this.bus);
        }
    }

    public void preShutdown() {
    }

    public void postShutdown() {
    }

    static {
        boolean b = false;
        boolean pretty = false;
        try {
            String prop = System.getProperty("org.apache.cxf.logging.enabled", "false");
            if ("pretty".equals(prop)) {
                b = true;
                pretty = true;
            } else {
                b = Boolean.parseBoolean(prop);
                b |= Boolean.getBoolean("com.sun.xml.ws.transport.local.LocalTransportPipe.dump");
                b |= Boolean.getBoolean("com.sun.xml.ws.util.pipe.StandaloneTubeAssembler.dump");
                b |= Boolean.getBoolean("com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump");
                b |= Boolean.getBoolean("com.sun.xml.ws.transport.http.HttpAdapter.dump");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FORCE_LOGGING = b;
        FORCE_PRETTY = pretty;
    }
}

