/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.ipc.AvroRemoteException;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.Stringable;
import org.apache.avro.reflect.Union;
import org.apache.avro.specific.FixedSize;
import org.apache.avro.specific.SpecificData;

public class ReflectData
extends SpecificData {
    private static final ReflectData INSTANCE = new ReflectData();
    private static final Map<Class, Map<String, Field>> FIELD_CACHE = new ConcurrentHashMap<Class, Map<String, Field>>();
    static final String CLASS_PROP = "java-class";
    static final String ELEMENT_PROP = "java-element-class";
    private static final Class BYTES_CLASS = new byte[0].getClass();
    private static final Schema THROWABLE_MESSAGE = ReflectData.makeNullable(Schema.create(Schema.Type.STRING));
    private final Paranamer paranamer = new CachingParanamer();

    protected ReflectData() {
    }

    public static ReflectData get() {
        return INSTANCE;
    }

    @Override
    protected boolean isRecord(Object datum) {
        if (datum == null) {
            return false;
        }
        return this.getSchema(datum.getClass()).getType() == Schema.Type.RECORD;
    }

    @Override
    protected boolean isArray(Object datum) {
        return datum instanceof Collection || datum.getClass().isArray();
    }

    @Override
    protected boolean isBytes(Object datum) {
        if (datum == null) {
            return false;
        }
        Class<?> c = datum.getClass();
        return c.isArray() && c.getComponentType() == Byte.TYPE;
    }

    @Override
    protected Schema getRecordSchema(Object record) {
        return this.getSchema(record.getClass());
    }

    @Override
    public boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (datum == null) {
                    return false;
                }
                Class<?> c = datum.getClass();
                for (Schema.Field f : schema.getFields()) {
                    try {
                        if (this.validate(f.schema(), ReflectData.getField(c, f.name()).get(datum))) continue;
                        return false;
                    }
                    catch (IllegalAccessException e) {
                        throw new AvroRuntimeException(e);
                    }
                }
                return true;
            }
            case ARRAY: {
                if (datum instanceof Collection) {
                    for (Object element : (Collection)datum) {
                        if (this.validate(schema.getElementType(), element)) continue;
                        return false;
                    }
                    return true;
                }
                if (datum.getClass().isArray()) {
                    int length = Array.getLength(datum);
                    for (int i = 0; i < length; ++i) {
                        if (this.validate(schema.getElementType(), Array.get(datum, i))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return super.validate(schema, datum);
    }

    protected static Field getField(Class c, String name) {
        Field f;
        Map<String, Field> fields = FIELD_CACHE.get(c);
        if (fields == null) {
            fields = new ConcurrentHashMap<String, Field>();
            FIELD_CACHE.put(c, fields);
        }
        if ((f = fields.get(name)) == null) {
            f = ReflectData.findField(c, name);
            fields.put(name, f);
        }
        return f;
    }

    private static Field findField(Class c, String name) {
        while (true) {
            try {
                Field f = c.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((c = c.getSuperclass()) != null) continue;
                throw new AvroRuntimeException("No field named " + name + " in: " + c);
            }
            break;
        }
    }

    static Class getClassProp(Schema schema, String prop) {
        String name = schema.getProp(prop);
        if (name == null) {
            return null;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public Class getClass(Schema schema) {
        switch (schema.getType()) {
            case ARRAY: {
                Class collectionClass = ReflectData.getClassProp(schema, CLASS_PROP);
                if (collectionClass != null) {
                    return collectionClass;
                }
                return Array.newInstance(this.getClass(schema.getElementType()), 0).getClass();
            }
            case STRING: {
                return String.class;
            }
            case BYTES: {
                return BYTES_CLASS;
            }
            case INT: {
                if (!Short.class.getName().equals(schema.getProp(CLASS_PROP))) break;
                return Short.TYPE;
            }
        }
        return super.getClass(schema);
    }

    @Override
    protected Schema createSchema(Type type, Map<String, Schema> names) {
        if (type instanceof GenericArrayType) {
            Type component = ((GenericArrayType)type).getGenericComponentType();
            if (component == Byte.TYPE) {
                return Schema.create(Schema.Type.BYTES);
            }
            Schema result = Schema.createArray(this.createSchema(component, names));
            this.setElement(result, component);
            return result;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class raw = (Class)ptype.getRawType();
            Type[] params = ptype.getActualTypeArguments();
            if (Map.class.isAssignableFrom(raw)) {
                Type key = params[0];
                Type value = params[1];
                if (key != String.class) {
                    throw new AvroTypeException("Map key class not String: " + key);
                }
                return Schema.createMap(this.createSchema(value, names));
            }
            if (Collection.class.isAssignableFrom(raw)) {
                if (params.length != 1) {
                    throw new AvroTypeException("No array type specified.");
                }
                Schema schema = Schema.createArray(this.createSchema(params[0], names));
                schema.addProp(CLASS_PROP, raw.getName());
                return schema;
            }
        } else {
            if (type == Short.class || type == Short.TYPE) {
                Schema result = Schema.create(Schema.Type.INT);
                result.addProp(CLASS_PROP, Short.class.getName());
                return result;
            }
            if (type instanceof Class) {
                Class c = (Class)type;
                if (c.isPrimitive() || Number.class.isAssignableFrom(c) || c == Void.class || c == Boolean.class) {
                    return super.createSchema(type, names);
                }
                if (c.isArray()) {
                    Class<?> component = c.getComponentType();
                    if (component == Byte.TYPE) {
                        return Schema.create(Schema.Type.BYTES);
                    }
                    Schema result = Schema.createArray(this.createSchema(component, names));
                    this.setElement(result, component);
                    return result;
                }
                if (CharSequence.class.isAssignableFrom(c)) {
                    return Schema.create(Schema.Type.STRING);
                }
                String fullName = c.getName();
                Schema schema = names.get(fullName);
                if (schema == null) {
                    Union union;
                    String space;
                    String name = c.getSimpleName();
                    String string = space = c.getPackage() == null ? "" : c.getPackage().getName();
                    if (c.getEnclosingClass() != null) {
                        space = c.getEnclosingClass().getName() + "$";
                    }
                    if ((union = c.getAnnotation(Union.class)) != null) {
                        return this.getAnnotatedUnion(union, names);
                    }
                    if (c.isAnnotationPresent(Stringable.class)) {
                        Schema result = Schema.create(Schema.Type.STRING);
                        result.addProp(CLASS_PROP, c.getName());
                        return result;
                    }
                    if (c.isEnum()) {
                        ArrayList<String> symbols = new ArrayList<String>();
                        Enum[] constants = (Enum[])c.getEnumConstants();
                        for (int i = 0; i < constants.length; ++i) {
                            symbols.add(constants[i].name());
                        }
                        schema = Schema.createEnum(name, null, space, symbols);
                    } else if (GenericFixed.class.isAssignableFrom(c)) {
                        int size = c.getAnnotation(FixedSize.class).value();
                        schema = Schema.createFixed(name, null, space, size);
                    } else {
                        if (IndexedRecord.class.isAssignableFrom(c)) {
                            return super.createSchema(type, names);
                        }
                        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                        boolean error = Throwable.class.isAssignableFrom(c);
                        schema = Schema.createRecord(name, null, space, error);
                        names.put(c.getName(), schema);
                        for (Field field : this.getFields(c)) {
                            if ((field.getModifiers() & 0x88) != 0) continue;
                            Schema fieldSchema = this.createFieldSchema(field, names);
                            fields.add(new Schema.Field(field.getName(), fieldSchema, null, null));
                        }
                        if (error) {
                            fields.add(new Schema.Field("detailMessage", THROWABLE_MESSAGE, null, null));
                        }
                        schema.setFields(fields);
                    }
                    names.put(fullName, schema);
                }
                return schema;
            }
        }
        return super.createSchema(type, names);
    }

    private void setElement(Schema schema, Type element) {
        if (!(element instanceof Class)) {
            return;
        }
        Class c = (Class)element;
        Union union = c.getAnnotation(Union.class);
        if (union != null) {
            schema.addProp(ELEMENT_PROP, c.getName());
        }
    }

    private Schema getAnnotatedUnion(Union union, Map<String, Schema> names) {
        ArrayList<Schema> branches = new ArrayList<Schema>();
        for (Class branch : union.value()) {
            branches.add(this.createSchema(branch, names));
        }
        return Schema.createUnion(branches);
    }

    public static Schema makeNullable(Schema schema) {
        return Schema.createUnion(Arrays.asList(Schema.create(Schema.Type.NULL), schema));
    }

    private Collection<Field> getFields(Class recordClass) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        Class c = recordClass;
        while (c.getPackage() == null || !c.getPackage().getName().startsWith("java.")) {
            for (Field field : c.getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0 || fields.put(field.getName(), field) == null) continue;
                throw new AvroTypeException(c + " contains two fields named: " + field);
            }
            if ((c = c.getSuperclass()) != null) continue;
        }
        return fields.values();
    }

    protected Schema createFieldSchema(Field field, Map<String, Schema> names) {
        Schema schema = this.createSchema(field.getGenericType(), names);
        if (field.isAnnotationPresent(Nullable.class)) {
            schema = ReflectData.makeNullable(schema);
        }
        return schema;
    }

    @Override
    public Protocol getProtocol(Class iface) {
        Protocol protocol = new Protocol(iface.getSimpleName(), iface.getPackage() == null ? "" : iface.getPackage().getName());
        LinkedHashMap<String, Schema> names = new LinkedHashMap<String, Schema>();
        Map<String, Protocol.Message> messages = protocol.getMessages();
        for (Method method : iface.getMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            String name = method.getName();
            if (messages.containsKey(name)) {
                throw new AvroTypeException("Two methods with same name: " + name);
            }
            messages.put(name, this.getMessage(method, protocol, names));
        }
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.addAll(names.values());
        Collections.reverse(types);
        protocol.setTypes(types);
        return protocol;
    }

    private Protocol.Message getMessage(Method method, Protocol protocol, Map<String, Schema> names) {
        Schema response;
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        String[] paramNames = this.paranamer.lookupParameterNames((AccessibleObject)method);
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            Schema paramSchema = this.getSchema(paramTypes[i], names);
            for (int j = 0; j < annotations[i].length; ++j) {
                if (annotations[i][j] instanceof Union) {
                    paramSchema = this.getAnnotatedUnion((Union)annotations[i][j], names);
                    continue;
                }
                if (!(annotations[i][j] instanceof Nullable)) continue;
                paramSchema = ReflectData.makeNullable(paramSchema);
            }
            String paramName = paramNames.length == paramTypes.length ? paramNames[i] : paramSchema.getName() + i;
            fields.add(new Schema.Field(paramName, paramSchema, null, null));
        }
        Schema request = Schema.createRecord(fields);
        Union union = method.getAnnotation(Union.class);
        Schema schema = response = union == null ? this.getSchema(method.getGenericReturnType(), names) : this.getAnnotatedUnion(union, names);
        if (method.isAnnotationPresent(Nullable.class)) {
            response = ReflectData.makeNullable(response);
        }
        ArrayList<Schema> errs = new ArrayList<Schema>();
        errs.add(Protocol.SYSTEM_ERROR);
        for (Type err : method.getGenericExceptionTypes()) {
            if (err == AvroRemoteException.class) continue;
            errs.add(this.getSchema(err, names));
        }
        Schema errors = Schema.createUnion(errs);
        return protocol.createMessage(method.getName(), null, request, response, errors);
    }

    private Schema getSchema(Type type, Map<String, Schema> names) {
        try {
            return this.createSchema(type, names);
        }
        catch (AvroTypeException e) {
            throw new AvroTypeException("Error getting schema for " + type + ": " + e.getMessage(), e);
        }
    }

    @Override
    public int compare(Object o1, Object o2, Schema s) {
        throw new UnsupportedOperationException();
    }

    public static class AllowNull
    extends ReflectData {
        private static final AllowNull INSTANCE = new AllowNull();

        public static AllowNull get() {
            return INSTANCE;
        }

        @Override
        protected Schema createFieldSchema(Field field, Map<String, Schema> names) {
            Schema schema = super.createFieldSchema(field, names);
            return AllowNull.makeNullable(schema);
        }
    }
}

