/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.protobuf.compiler;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.protobuf.compiler.AltJavaGenerator;
import org.apache.activemq.protobuf.compiler.CompilerException;
import org.apache.activemq.protobuf.compiler.JavaGenerator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ProtoMojo
extends AbstractMojo {
    protected MavenProject project;
    private File sourceDirectory;
    private File outputDirectory;
    private String type;

    public void execute() throws MojoExecutionException {
        File[] files = this.sourceDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".proto");
            }
        });
        if (files == null || files.length == 0) {
            this.getLog().warn((CharSequence)("No proto files found in directory: " + this.sourceDirectory.getPath()));
            return;
        }
        List<File> recFiles = Arrays.asList(files);
        for (File file : recFiles) {
            try {
                Object generator;
                this.getLog().info((CharSequence)("Compiling: " + file.getPath()));
                if ("default".equals(this.type)) {
                    generator = new JavaGenerator();
                    ((JavaGenerator)generator).setOut(this.outputDirectory);
                    ((JavaGenerator)generator).compile(file);
                    continue;
                }
                if (!"alt".equals(this.type)) continue;
                generator = new AltJavaGenerator();
                ((AltJavaGenerator)generator).setOut(this.outputDirectory);
                ((AltJavaGenerator)generator).compile(file);
            }
            catch (CompilerException e) {
                this.getLog().error((CharSequence)"Protocol Buffer Compiler failed with the following error(s):");
                for (String error2 : e.getErrors()) {
                    this.getLog().error((CharSequence)"");
                    this.getLog().error((CharSequence)error2);
                }
                this.getLog().error((CharSequence)"");
                throw new MojoExecutionException("Compile failed.  For more details see error messages listed above.", (Exception)e);
            }
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }
}

