/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v3;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v3.BaseCommandMarshaller;

public class ConnectionInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 3;
    }

    @Override
    public DataStructure createObject() {
        return new ConnectionInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ConnectionInfo info2 = (ConnectionInfo)o;
        info2.setConnectionId((ConnectionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setClientId(this.tightUnmarshalString(dataIn, bs));
        info2.setPassword(this.tightUnmarshalString(dataIn, bs));
        info2.setUserName(this.tightUnmarshalString(dataIn, bs));
        if (bs.readBoolean()) {
            int size2 = dataIn.readShort();
            BrokerId[] value = new BrokerId[size2];
            for (int i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info2.setBrokerPath(value);
        } else {
            info2.setBrokerPath(null);
        }
        info2.setBrokerMasterConnector(bs.readBoolean());
        info2.setManageable(bs.readBoolean());
        info2.setClientMaster(bs.readBoolean());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConnectionInfo info2 = (ConnectionInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getConnectionId(), bs);
        rc += this.tightMarshalString1(info2.getClientId(), bs);
        rc += this.tightMarshalString1(info2.getPassword(), bs);
        rc += this.tightMarshalString1(info2.getUserName(), bs);
        bs.writeBoolean(info2.isBrokerMasterConnector());
        bs.writeBoolean(info2.isManageable());
        bs.writeBoolean(info2.isClientMaster());
        return (rc += this.tightMarshalObjectArray1(wireFormat, info2.getBrokerPath(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ConnectionInfo info2 = (ConnectionInfo)o;
        this.tightMarshalCachedObject2(wireFormat, info2.getConnectionId(), dataOut, bs);
        this.tightMarshalString2(info2.getClientId(), dataOut, bs);
        this.tightMarshalString2(info2.getPassword(), dataOut, bs);
        this.tightMarshalString2(info2.getUserName(), dataOut, bs);
        this.tightMarshalObjectArray2(wireFormat, info2.getBrokerPath(), dataOut, bs);
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ConnectionInfo info2 = (ConnectionInfo)o;
        info2.setConnectionId((ConnectionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setClientId(this.looseUnmarshalString(dataIn));
        info2.setPassword(this.looseUnmarshalString(dataIn));
        info2.setUserName(this.looseUnmarshalString(dataIn));
        if (dataIn.readBoolean()) {
            int size2 = dataIn.readShort();
            BrokerId[] value = new BrokerId[size2];
            for (int i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info2.setBrokerPath(value);
        } else {
            info2.setBrokerPath(null);
        }
        info2.setBrokerMasterConnector(dataIn.readBoolean());
        info2.setManageable(dataIn.readBoolean());
        info2.setClientMaster(dataIn.readBoolean());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ConnectionInfo info2 = (ConnectionInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getConnectionId(), dataOut);
        this.looseMarshalString(info2.getClientId(), dataOut);
        this.looseMarshalString(info2.getPassword(), dataOut);
        this.looseMarshalString(info2.getUserName(), dataOut);
        this.looseMarshalObjectArray(wireFormat, info2.getBrokerPath(), dataOut);
        dataOut.writeBoolean(info2.isBrokerMasterConnector());
        dataOut.writeBoolean(info2.isManageable());
        dataOut.writeBoolean(info2.isClientMaster());
    }
}

