/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.util.DataByteArrayInputStream;

class StoreIndexReader {
    protected RandomAccessFile file;
    protected DataByteArrayInputStream dataIn;
    protected byte[] buffer = new byte[51];

    StoreIndexReader(RandomAccessFile file) {
        this.file = file;
        this.dataIn = new DataByteArrayInputStream();
    }

    protected IndexItem readItem(long offset) throws IOException {
        this.file.seek(offset);
        this.file.readFully(this.buffer);
        this.dataIn.restart(this.buffer);
        IndexItem result = new IndexItem();
        result.setOffset(offset);
        result.read(this.dataIn);
        return result;
    }

    void updateIndexes(IndexItem indexItem) throws IOException {
        if (indexItem != null) {
            this.file.seek(indexItem.getOffset());
            this.file.readFully(this.buffer, 0, 19);
            this.dataIn.restart(this.buffer);
            indexItem.readIndexes(this.dataIn);
        }
    }
}

