/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.DataFile;
import org.apache.activemq.kaha.impl.async.DataFileAppender;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.util.ByteSequence;

final class DataFileAccessor {
    private final DataFile dataFile;
    private final Map<DataFileAppender.WriteKey, DataFileAppender.WriteCommand> inflightWrites;
    private final RandomAccessFile file;
    private boolean disposed;

    public DataFileAccessor(AsyncDataManager dataManager, DataFile dataFile) throws IOException {
        this.dataFile = dataFile;
        this.inflightWrites = dataManager.getInflightWrites();
        this.file = dataFile.openRandomAccessFile(false);
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        try {
            this.dataFile.closeRandomAccessFile(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ByteSequence readRecord(Location location) throws IOException {
        if (!location.isValid()) {
            throw new IOException("Invalid location: " + location);
        }
        DataFileAppender.WriteCommand asyncWrite = this.inflightWrites.get(new DataFileAppender.WriteKey(location));
        if (asyncWrite != null) {
            return asyncWrite.data;
        }
        try {
            if (location.getSize() == -1) {
                this.file.seek(location.getOffset());
                location.setSize(this.file.readInt());
                this.file.seek(location.getOffset() + 29);
            } else {
                this.file.seek(location.getOffset() + 29);
            }
            byte[] data = new byte[location.getSize() - 32];
            this.file.readFully(data);
            return new ByteSequence(data, 0, data.length);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid location: " + location + ", : " + e);
        }
    }

    public void readLocationDetails(Location location) throws IOException {
        DataFileAppender.WriteCommand asyncWrite = this.inflightWrites.get(new DataFileAppender.WriteKey(location));
        if (asyncWrite != null) {
            location.setSize(asyncWrite.location.getSize());
            location.setType(asyncWrite.location.getType());
        } else {
            this.file.seek(location.getOffset());
            location.setSize(this.file.readInt());
            location.setType(this.file.readByte());
        }
    }

    public boolean readLocationDetailsAndValidate(Location location) {
        try {
            DataFileAppender.WriteCommand asyncWrite = this.inflightWrites.get(new DataFileAppender.WriteKey(location));
            if (asyncWrite != null) {
                location.setSize(asyncWrite.location.getSize());
                location.setType(asyncWrite.location.getType());
            } else {
                this.file.seek(location.getOffset());
                location.setSize(this.file.readInt());
                location.setType(this.file.readByte());
                byte[] data = new byte[3];
                this.file.seek(location.getOffset() + 26);
                this.file.readFully(data);
                if (data[0] != AsyncDataManager.ITEM_HEAD_SOR[0] || data[1] != AsyncDataManager.ITEM_HEAD_SOR[1] || data[2] != AsyncDataManager.ITEM_HEAD_SOR[2]) {
                    return false;
                }
                this.file.seek(location.getOffset() + location.getSize() - 3);
                this.file.readFully(data);
                if (data[0] != AsyncDataManager.ITEM_HEAD_EOR[0] || data[1] != AsyncDataManager.ITEM_HEAD_EOR[1] || data[2] != AsyncDataManager.ITEM_HEAD_EOR[2]) {
                    return false;
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void updateRecord(Location location, ByteSequence data, boolean sync) throws IOException {
        this.file.seek(location.getOffset() + 29);
        int size2 = Math.min(data.getLength(), location.getSize());
        this.file.write(data.getData(), data.getOffset(), size2);
        if (sync) {
            this.file.getFD().sync();
        }
    }
}

