/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.StereotypeFacade;
import org.andromda.metafacades.uml14.ValueObjectLogic;

public class ValueObjectLogicImpl
extends ValueObjectLogic {
    private static final long serialVersionUID = 6729122952696837826L;

    public ValueObjectLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected Collection<ValueObjectLogic> handleGetTypeSpecializations() {
        StringBuilder stereotypes = new StringBuilder();
        Iterator<StereotypeFacade> iterator = this.getStereotypes().iterator();
        while (iterator.hasNext()) {
            stereotypes.append(iterator.next().getName()).append(',');
        }
        return this.handleGetTypeSpecializations(stereotypes.toString());
    }

    protected Collection<ValueObjectLogic> handleGetTypeSpecializations(String stereotypes) {
        TreeSet<ValueObjectLogic> specializations = new TreeSet<ValueObjectLogic>();
        String[] stereotypeList = stereotypes.split(",", -1);
        for (GeneralizableElementFacade classifier : this.getAllSpecializations()) {
            if (!(classifier instanceof ValueObjectLogic)) continue;
            for (int i = 0; i < stereotypeList.length; ++i) {
                if (!classifier.hasStereotype(stereotypeList[i]) || specializations.contains(classifier)) continue;
                specializations.add((ValueObjectLogic)classifier);
            }
        }
        return specializations;
    }
}

