/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.andromda.metafacades.uml.ActivityGraphFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.UseCaseFacade;
import org.andromda.metafacades.uml14.ModelFacadeLogic;
import org.andromda.metafacades.uml14.UML14MetafacadeUtils;
import org.apache.commons.collections.Predicate;
import org.omg.uml.UmlPackage;
import org.omg.uml.behavioralelements.activitygraphs.ActionState;
import org.omg.uml.behavioralelements.activitygraphs.ActivityGraph;
import org.omg.uml.behavioralelements.statemachines.CompositeState;
import org.omg.uml.behavioralelements.usecases.UseCase;
import org.omg.uml.foundation.core.ModelElement;

public class ModelFacadeLogicImpl
extends ModelFacadeLogic {
    private static final long serialVersionUID = 34L;

    public ModelFacadeLogicImpl(UmlPackage metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected Object handleGetRootPackage() {
        Collection rootPackages = this.metaObject.getModelManagement().getModel().refAllOfType();
        return rootPackages.iterator().next();
    }

    @Override
    protected Collection handleGetAllActors() {
        return this.metaObject.getUseCases().getActor().refAllOfType();
    }

    @Override
    protected Collection handleGetAllActionStates() {
        return this.metaObject.getActivityGraphs().getActionState().refAllOfType();
    }

    @Override
    protected Collection handleGetAllUseCases() {
        return this.metaObject.getUseCases().getUseCase().refAllOfType();
    }

    @Override
    protected Collection handleGetAllClasses() {
        return this.metaObject.getCore().getUmlClass().refAllOfType();
    }

    @Override
    protected Collection handleGetAllObjectFlowStates() {
        return this.metaObject.getActivityGraphs().getObjectFlowState().refAllOfType();
    }

    @Override
    protected UseCaseFacade handleFindUseCaseWithTaggedValueOrHyperlink(String tag, String value) {
        return (UseCaseFacade)this.shieldedElement(UML14MetafacadeUtils.findUseCaseWithTaggedValueOrHyperlink(tag, value));
    }

    @Override
    protected ClassifierFacade handleFindClassWithTaggedValueOrHyperlink(String tag, String value) {
        return (ClassifierFacade)this.shieldedElement(UML14MetafacadeUtils.findClassWithTaggedValueOrHyperlink(tag, value));
    }

    @Override
    protected ActivityGraphFacade handleFindActivityGraphByName(String name) {
        return (ActivityGraphFacade)this.shieldedElement(UML14MetafacadeUtils.findFirstActivityGraphWithName(name));
    }

    @Override
    protected ActivityGraphFacade handleFindActivityGraphByNameAndStereotype(String name, String stereotypeName) {
        return (ActivityGraphFacade)this.shieldedElement(UML14MetafacadeUtils.findFirstActivityGraphWithNameAndStereotype(name, stereotypeName));
    }

    @Override
    protected UseCaseFacade handleFindUseCaseByName(String name) {
        return (UseCaseFacade)this.shieldedElement(UML14MetafacadeUtils.findFirstUseCaseWithName(name));
    }

    @Override
    protected UseCaseFacade handleFindUseCaseWithNameAndStereotype(String name, String stereotypeName) {
        return (UseCaseFacade)this.shieldedElement(UML14MetafacadeUtils.findFirstUseCaseWithNameAndStereotype(name, stereotypeName));
    }

    @Override
    protected Collection handleFindFinalStatesWithNameOrHyperlink(UseCaseFacade useCase) {
        UseCase useCaseMetaClass = UML14MetafacadeUtils.getMetaClass(useCase);
        return this.shieldedElements(UML14MetafacadeUtils.findFinalStatesWithNameOrHyperlink(useCaseMetaClass));
    }

    @Override
    protected Collection handleGetAllActionStatesWithStereotype(ActivityGraphFacade activityGraph, String stereotypeName) {
        ActivityGraph activityGraphMetaClass = UML14MetafacadeUtils.getMetaClass(activityGraph);
        CompositeState compositeState = (CompositeState)activityGraphMetaClass.getTop();
        return this.filter(compositeState.getSubvertex(), new ActionStateWithStereotypeFilter(stereotypeName));
    }

    @Override
    protected Collection handleGetAllTransitions() {
        return this.metaObject.getStateMachines().getTransition().refAllOfType();
    }

    private Collection filter(Collection collection, Predicate collectionFilter) {
        LinkedHashSet filteredCollection = new LinkedHashSet();
        for (Object object : collection) {
            if (!collectionFilter.evaluate(object)) continue;
            filteredCollection.add(object);
        }
        return filteredCollection;
    }

    private static final class ActionStateWithStereotypeFilter
    implements Predicate {
        private String stereotypeName = null;

        public ActionStateWithStereotypeFilter(String stereotypeName) {
            this.stereotypeName = stereotypeName;
        }

        public boolean evaluate(Object object) {
            return object instanceof ActionState && UML14MetafacadeUtils.isStereotypePresent((ModelElement)object, this.stereotypeName);
        }
    }
}

