/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.GeneralizationFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml14.GeneralizableElementFacadeLogic;
import org.andromda.metafacades.uml14.UML14MetafacadeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.omg.uml.foundation.core.GeneralizableElement;
import org.omg.uml.foundation.core.Generalization;

public class GeneralizableElementFacadeLogicImpl
extends GeneralizableElementFacadeLogic {
    private static final long serialVersionUID = 34L;

    public GeneralizableElementFacadeLogicImpl(GeneralizableElement metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    public Collection<GeneralizableElementFacade> handleGetAllGeneralizations() {
        ArrayList<GeneralizableElementFacade> generalizations = new ArrayList<GeneralizableElementFacade>();
        for (GeneralizableElementFacade element : this.getGeneralizations()) {
            generalizations.add(element);
            generalizations.addAll(element.getAllGeneralizations());
        }
        return generalizations;
    }

    public GeneralizableElement handleGetGeneralization() {
        Iterator iterator;
        GeneralizableElement parent = null;
        Collection generalizations = this.metaObject.getGeneralization();
        if (generalizations != null && (iterator = generalizations.iterator()).hasNext()) {
            parent = ((Generalization)iterator.next()).getParent();
        }
        return parent;
    }

    @Override
    protected Collection<GeneralizableElementFacade> handleGetGeneralizations() {
        LinkedHashSet<GeneralizableElement> parents = new LinkedHashSet<GeneralizableElement>();
        Collection generalizations = this.metaObject.getGeneralization();
        if (generalizations != null && !generalizations.isEmpty()) {
            for (Generalization generalization : generalizations) {
                parents.add(generalization.getParent());
            }
        }
        return this.shieldedElements(parents);
    }

    @Override
    protected Collection<GeneralizationFacade> handleGetGeneralizationLinks() {
        return this.shieldedElements(this.metaObject.getGeneralization());
    }

    @Override
    public Collection<GeneralizableElement> handleGetSpecializations() {
        ArrayList<GeneralizableElement> specializations = new ArrayList<GeneralizableElement>(UML14MetafacadeUtils.getCorePackage().getAParentSpecialization().getSpecialization(this.metaObject));
        CollectionUtils.transform(specializations, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return ((Generalization)object).getChild();
            }
        });
        return specializations;
    }

    @Override
    protected String handleGetGeneralizationList() {
        StringBuilder list = new StringBuilder();
        if (this.getGeneralizations() != null) {
            Iterator<GeneralizableElementFacade> iterator = this.getGeneralizations().iterator();
            while (iterator.hasNext()) {
                list.append(((ModelElementFacade)iterator.next()).getFullyQualifiedName());
                if (!iterator.hasNext()) continue;
                list.append(", ");
            }
        }
        return list.toString();
    }

    @Override
    protected Collection<GeneralizableElementFacade> handleGetAllSpecializations() {
        LinkedHashSet<GeneralizableElementFacade> allSpecializations = new LinkedHashSet<GeneralizableElementFacade>();
        if (this.getSpecializations() != null) {
            allSpecializations.addAll(this.getSpecializations());
            for (GeneralizableElementFacade element : this.getSpecializations()) {
                allSpecializations.addAll(element.getAllSpecializations());
            }
        }
        return allSpecializations;
    }

    @Override
    protected Object handleFindTaggedValue(String tagName, boolean follow) {
        Object value = this.findTaggedValue(tagName);
        if (value == null) {
            for (GeneralizableElementFacade element = this.getGeneralization(); value == null && element != null; element = element.getGeneralization()) {
                value = element.findTaggedValue(tagName, follow);
            }
        }
        return value;
    }

    protected GeneralizableElementFacade handleGetGeneralizationRoot() {
        return this.getGeneralization() == null ? (GeneralizableElementFacade)this.THIS() : this.getGeneralization().getGeneralizationRoot();
    }
}

