/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import org.andromda.cartridges.hibernate.metafacades.HibernateTypeLogic;
import org.andromda.core.common.ExceptionRecorder;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.utils.JavaTypeConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HibernateTypeLogicImpl
extends HibernateTypeLogic {
    private static final long serialVersionUID = 34L;
    private static final Logger logger = Logger.getLogger(HibernateTypeLogicImpl.class);

    public HibernateTypeLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetFullyQualifiedHibernateType() {
        String fullyQualifiedName = super.getFullyQualifiedName();
        TypeMappings mappings = this.getHibernateTypeMappings();
        if (mappings != null) {
            String fullyQualifiedModelName = super.getFullyQualifiedName(true);
            if (mappings.getMappings().containsFrom(fullyQualifiedModelName)) {
                fullyQualifiedName = mappings.getTo(fullyQualifiedModelName);
            }
        }
        fullyQualifiedName = JavaTypeConverter.getJavaLangTypeName((String)fullyQualifiedName);
        return fullyQualifiedName;
    }

    protected TypeMappings getHibernateTypeMappings() {
        TypeMappings mappings = null;
        String propertyName = "hibernateTypeMappingsUri";
        if (this.isConfiguredProperty("hibernateTypeMappingsUri")) {
            Object property = this.getConfiguredProperty("hibernateTypeMappingsUri");
            String uri = null;
            if (property instanceof String) {
                uri = (String)property;
                if (StringUtils.isNotBlank((String)uri)) {
                    try {
                        mappings = TypeMappings.getInstance((String)((String)property));
                        this.setProperty("hibernateTypeMappingsUri", mappings);
                    }
                    catch (Throwable throwable) {
                        String message = "Error getting 'hibernateTypeMappingsUri' --> '" + uri + '\'';
                        logger.error((Object)message);
                        ExceptionRecorder.instance().record(message, throwable);
                    }
                }
            } else {
                mappings = (TypeMappings)property;
            }
        }
        return mappings;
    }
}

