/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import java.util.Collection;
import org.andromda.cartridges.hibernate.HibernateProfile;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

class HibernateMetafacadeUtils {
    HibernateMetafacadeUtils() {
    }

    static String getViewType(ClassifierFacade classifier, String defaultViewType) {
        ExceptionUtils.checkNull((String)"classifer", (Object)classifier);
        String viewType = null;
        if (classifier.hasStereotype(HibernateProfile.STEREOTYPE_SERVICE)) {
            String viewTypeValue = (String)classifier.findTaggedValue(HibernateProfile.TAGGEDVALUE_EJB_VIEWTYPE);
            if (StringUtils.isEmpty((String)viewTypeValue)) {
                viewType = (String)CollectionUtils.find((Collection)classifier.getAllGeneralizations(), (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        return ((ModelElementFacade)object).findTaggedValue(HibernateProfile.TAGGEDVALUE_EJB_VIEWTYPE) != null;
                    }
                });
            }
            if (StringUtils.isNotBlank((String)viewTypeValue)) {
                viewType = viewTypeValue;
            }
        }
        if (StringUtils.isEmpty(viewType) || viewType == null) {
            viewType = defaultViewType;
        }
        return viewType.toLowerCase();
    }

    static String getFullyQualifiedName(String packageName, String name, String suffix) {
        StringBuilder fullyQualifiedName = new StringBuilder(StringUtils.trimToEmpty((String)packageName));
        if (StringUtils.isNotBlank((String)packageName)) {
            fullyQualifiedName.append('.');
        }
        fullyQualifiedName.append(StringUtils.trimToEmpty((String)name));
        fullyQualifiedName.append(StringUtils.trimToEmpty((String)suffix));
        return fullyQualifiedName.toString();
    }

    static Collection<OperationFacade> filterBusinessOperations(Collection<OperationFacade> operations) {
        FilteredCollection businessOperations = new FilteredCollection(operations){
            private static final long serialVersionUID = 34L;

            public boolean evaluate(Object object) {
                return !((OperationFacade)object).isStatic();
            }
        };
        return businessOperations;
    }

    static boolean getUseNamedParameters(OperationFacade operation, boolean defaultUseNamedParameters) {
        String useNamedParametersValue;
        ExceptionUtils.checkNull((String)"operation", (Object)operation);
        boolean useNamedParameters = defaultUseNamedParameters;
        if (operation.isQuery() && StringUtils.isNotBlank((String)(useNamedParametersValue = StringUtils.trimToEmpty((String)((String)operation.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_USE_NAMED_PARAMETERS)))))) {
            useNamedParameters = Boolean.valueOf(useNamedParametersValue);
        }
        return useNamedParameters;
    }
}

