/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import org.andromda.cartridges.hibernate.metafacades.HibernateEnumerationLogic;
import org.andromda.cartridges.hibernate.metafacades.HibernateMetafacadeUtils;
import org.andromda.utils.JavaTypeConverter;
import org.apache.commons.lang.StringUtils;

public class HibernateEnumerationLogicImpl
extends HibernateEnumerationLogic {
    private static final long serialVersionUID = 34L;
    private static final String ENUMERATION_NAME_PATTERN = "enumerationNamePattern";

    public HibernateEnumerationLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    private String getEnumerationNamePattern() {
        return String.valueOf(this.getConfiguredProperty(ENUMERATION_NAME_PATTERN));
    }

    @Override
    protected String handleGetFullyQualifiedHibernateType() {
        return JavaTypeConverter.getJavaLangTypeName((String)super.getFullyQualifiedName());
    }

    @Override
    protected String handleGetEnumerationName() {
        return StringUtils.trimToEmpty((String)this.getEnumerationNamePattern()).replaceAll("\\{0\\}", super.getName());
    }

    @Override
    protected String handleGetFullyQualifiedHibernateEnumerationType() {
        return HibernateMetafacadeUtils.getFullyQualifiedName(this.getHibernateEnumerationPackageName(), this.getEnumerationName(), null);
    }

    private String getHibernateEnumerationPackageName() {
        String enumPackageName = (String)this.getConfiguredProperty("enumTypesPackage");
        if (enumPackageName != null) {
            return enumPackageName;
        }
        return super.getPackageName();
    }

    @Override
    protected int handleGetVersion() {
        return Integer.parseInt(((String)this.getConfiguredProperty("hibernateVersion")).substring(0, 1));
    }
}

