/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.andromda.cartridges.hibernate.HibernateProfile;
import org.andromda.cartridges.hibernate.HibernateUtils;
import org.andromda.cartridges.hibernate.metafacades.HibernateEntity;
import org.andromda.cartridges.hibernate.metafacades.HibernateEntityLogic;
import org.andromda.cartridges.hibernate.metafacades.HibernateMetafacadeUtils;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.EntityAttribute;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class HibernateEntityLogicImpl
extends HibernateEntityLogic {
    private static final long serialVersionUID = 34L;
    private static final String INHERITANCE_STRATEGY_CLASS = "class";
    private static final String INHERITANCE_STRATEGY_SUBCLASS = "subclass";
    private static final String INHERITANCE_STRATEGY_CONCRETE = "concrete";
    private static final String INHERITANCE_STRATEGY_INTERFACE = "interface";
    private static final String INHERITANCE_STRATEGY_UNION_SUBCLASS = "union-subclass";
    private static final Collection<String> inheritanceStrategies = new ArrayList<String>();
    private static final String INHERITANCE_STRATEGY = "hibernateInheritanceStrategy";
    private static final String HIBERNATE_ENTITY_CACHE = "hibernateEntityCache";
    private static final String HIBERNATE_DEFAULT_CASCADE = "hibernateDefaultCascade";
    private static final String DEFAULT_HIBERNATE_GENERATOR_CLASS = "defaultHibernateGeneratorClass";
    private static final String HIBERNATE_GENERATOR_CLASS_FOREIGN = "foreign";
    private static final String HIBERNATE_GENERATOR_CLASS_ASSIGNED = "assigned";
    private static final String HIBERNATE_GENERATOR_CLASS_SEQUENCE = "sequence";
    private static final String HIBERNATE_PROXY = "hibernateProxy";
    private static final String CLASS_MAPPING_NAME = "class";
    private static final String JOINED_SUBCLASS_MAPPING_NAME = "joined-subclass";
    private static final String SUBCLASS_MAPPING_NAME = "subclass";
    private static final String UNION_SUBCLASS_MAPPING_NAME = "union-subclass";
    private static final String SEQUENCE_IDENTIFIER_SUFFIX = "sequenceIdentifierSuffix";

    public HibernateEntityLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected Collection<OperationFacade> handleGetAllBusinessOperations() {
        Collection<OperationFacade> result = this.getBusinessOperations();
        GeneralizableElementFacade general = this.getGeneralization();
        if (general != null && general instanceof Entity) {
            Entity superElement = (Entity)general;
            result.addAll(superElement.getBusinessOperations());
            general = this.getGeneralization();
        }
        return result;
    }

    @Override
    protected String handleGetHibernateInheritanceStrategy() {
        String inheritance = HibernateEntityLogicImpl.getInheritance(this);
        HibernateEntity superEntity = this.getSuperEntity();
        while (superEntity != null && StringUtils.isBlank((String)inheritance)) {
            inheritance = superEntity.getHibernateInheritanceStrategy();
        }
        String string = inheritance = inheritance != null ? inheritance.toLowerCase() : null;
        if (StringUtils.isBlank((String)inheritance) || !inheritanceStrategies.contains(inheritance)) {
            inheritance = this.getDefaultInheritanceStrategy();
        }
        return inheritance;
    }

    private String getDefaultInheritanceStrategy() {
        return String.valueOf(this.getConfiguredProperty(INHERITANCE_STRATEGY));
    }

    private static String getInheritance(HibernateEntity entity) {
        Object value;
        String inheritance = null;
        if (entity != null && (value = entity.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_INHERITANCE)) != null) {
            inheritance = String.valueOf(value);
        }
        return inheritance;
    }

    @Override
    public List<ModelElementFacade> getProperties() {
        ArrayList<ModelElementFacade> properties = new ArrayList<ModelElementFacade>();
        properties.addAll(this.getAttributes());
        for (AssociationEndFacade end : this.getAssociationEnds()) {
            AssociationEndFacade otherEnd = end.getOtherEnd();
            if (!otherEnd.isNavigable() && (!end.isChild() || !this.isForeignHibernateGeneratorClass())) continue;
            properties.add((ModelElementFacade)otherEnd);
        }
        return properties;
    }

    @Override
    protected boolean handleIsHibernateInheritanceClass() {
        return this.getHibernateInheritanceStrategy().equalsIgnoreCase("class");
    }

    @Override
    protected boolean handleIsHibernateInheritanceInterface() {
        return this.getHibernateInheritanceStrategy().equalsIgnoreCase(INHERITANCE_STRATEGY_INTERFACE);
    }

    @Override
    protected boolean handleIsHibernateInheritanceSubclass() {
        return this.getHibernateInheritanceStrategy().equalsIgnoreCase("subclass");
    }

    @Override
    protected boolean handleIsHibernateInheritanceConcrete() {
        return this.getHibernateInheritanceStrategy().equalsIgnoreCase(INHERITANCE_STRATEGY_CONCRETE);
    }

    @Override
    protected boolean handleIsHibernateInheritanceUnionSubClass() {
        String version = (String)this.getConfiguredProperty("hibernateVersion");
        return (version.startsWith("3") || version.startsWith("4")) && this.getHibernateInheritanceStrategy().equalsIgnoreCase("union-subclass");
    }

    @Override
    protected boolean handleIsLazy() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_LAZY);
        if (StringUtils.isBlank((String)value)) {
            String version = (String)this.getConfiguredProperty("hibernateVersion");
            value = version.startsWith("2") ? "false" : "true";
        }
        return Boolean.valueOf(value);
    }

    @Override
    protected String handleGetHibernateCacheType() {
        String cacheType = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ENTITY_CACHE);
        if (StringUtils.isBlank((String)cacheType)) {
            cacheType = String.valueOf(this.getConfiguredProperty(HIBERNATE_ENTITY_CACHE));
        }
        return cacheType;
    }

    @Override
    protected String handleGetFullyQualifiedEntityName() {
        return HibernateMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getEntityName(), null);
    }

    @Override
    protected String handleGetFullyQualifiedEntityImplementationName() {
        return HibernateMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getEntityImplementationName(), null);
    }

    @Override
    protected String handleGetHibernateDefaultCascade() {
        return StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty(HIBERNATE_DEFAULT_CASCADE)));
    }

    @Override
    protected String handleGetHibernateGeneratorClass() {
        String hibernateGeneratorClass;
        if (this.isUsingForeignIdentifier()) {
            hibernateGeneratorClass = HIBERNATE_GENERATOR_CLASS_FOREIGN;
        } else if (this.isUsingAssignedIdentifier()) {
            hibernateGeneratorClass = HIBERNATE_GENERATOR_CLASS_ASSIGNED;
        } else {
            hibernateGeneratorClass = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_GENERATOR_CLASS, false);
            if (StringUtils.isBlank((String)hibernateGeneratorClass)) {
                hibernateGeneratorClass = (String)this.getConfiguredProperty(DEFAULT_HIBERNATE_GENERATOR_CLASS);
            }
        }
        return StringUtils.trimToEmpty((String)hibernateGeneratorClass);
    }

    @Override
    protected boolean handleIsForeignHibernateGeneratorClass() {
        return this.isUsingForeignIdentifier() || this.getHibernateGeneratorClass().equalsIgnoreCase(HIBERNATE_GENERATOR_CLASS_FOREIGN);
    }

    @Override
    protected boolean handleIsSequenceHibernateGeneratorClass() {
        return this.getHibernateGeneratorClass().equalsIgnoreCase(HIBERNATE_GENERATOR_CLASS_SEQUENCE);
    }

    @Override
    protected String handleGetEntityName() {
        String entityNamePattern = (String)this.getConfiguredProperty("entityNamePattern");
        return MessageFormat.format(entityNamePattern, StringUtils.trimToEmpty((String)this.getName()));
    }

    @Override
    protected String handleGetEntityImplementationName() {
        String implNamePattern = String.valueOf(this.getConfiguredProperty("entityImplementationNamePattern"));
        return MessageFormat.format(implNamePattern, StringUtils.trimToEmpty((String)this.getName()));
    }

    @Override
    protected String handleGetHibernateDiscriminatorColumn() {
        String column = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_ENTITY_DISCRIMINATOR_COLUMN);
        if (StringUtils.isBlank((String)column)) {
            column = String.valueOf(this.getConfiguredProperty("defaultEntityDiscriminatorColumn"));
        }
        return column;
    }

    @Override
    protected String handleGetHibernateDiscriminatorType() {
        String type = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_ENTITY_DISCRIMINATOR_TYPE);
        if (StringUtils.isBlank((String)type)) {
            type = String.valueOf(this.getConfiguredProperty("defaultEntityDiscriminatorType"));
        }
        return type;
    }

    @Override
    protected int handleGetHibernateDiscriminatorLength() {
        return 1;
    }

    @Override
    public Collection<OperationFacade> getBusinessOperations() {
        return HibernateMetafacadeUtils.filterBusinessOperations(super.getBusinessOperations());
    }

    @Override
    protected boolean handleIsBusinessOperationsPresent() {
        Collection allBusinessOperations = this.getAllBusinessOperations();
        return allBusinessOperations != null && !allBusinessOperations.isEmpty();
    }

    @Override
    protected boolean handleIsHibernateProxy() {
        String hibernateProxy = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_PROXY);
        if (StringUtils.isBlank((String)hibernateProxy)) {
            hibernateProxy = (String)this.getConfiguredProperty(HIBERNATE_PROXY);
        }
        return Boolean.valueOf(hibernateProxy);
    }

    @Override
    protected int handleGetEhCacheMaxElementsInMemory() {
        String maxElements = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_MAX_ELEMENTS);
        if (StringUtils.isBlank((String)maxElements)) {
            maxElements = (String)this.getConfiguredProperty("ehCacheMaxElementsInMemory");
        }
        return Integer.parseInt(StringUtils.trimToEmpty((String)maxElements));
    }

    @Override
    protected boolean handleIsEhCacheEternal() {
        String eternal = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_ETERNAL);
        if (StringUtils.isBlank((String)eternal)) {
            eternal = (String)this.getConfiguredProperty("ehCacheEternal");
        }
        return Boolean.valueOf(StringUtils.trimToEmpty((String)eternal));
    }

    @Override
    protected int handleGetEhCacheTimeToIdleSeconds() {
        String timeToIdle = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_TIME_TO_IDLE);
        if (StringUtils.isBlank((String)timeToIdle)) {
            timeToIdle = (String)this.getConfiguredProperty("ehCacheTimeToIdleSeconds");
        }
        return Integer.parseInt(StringUtils.trimToEmpty((String)timeToIdle));
    }

    @Override
    protected int handleGetEhCacheTimeToLiveSeconds() {
        String timeToLive = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_TIME_TO_LIVE);
        if (StringUtils.isBlank((String)timeToLive)) {
            timeToLive = (String)this.getConfiguredProperty("ehCacheTimeToLiveSeconds");
        }
        return Integer.parseInt(StringUtils.trimToEmpty((String)timeToLive));
    }

    @Override
    protected boolean handleIsEhCacheOverflowToDisk() {
        String eternal = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_OVERFLOW_TO_DISK);
        if (StringUtils.isBlank((String)eternal)) {
            eternal = (String)this.getConfiguredProperty("ehCacheOverflowToDisk");
        }
        return Boolean.valueOf(StringUtils.trimToEmpty((String)eternal));
    }

    @Override
    protected boolean handleIsHibernateCacheDistributed() {
        String distributed = (String)this.getConfiguredProperty("hibernateEnableDistributedCache");
        boolean distributedCachingEnabled = Boolean.valueOf(StringUtils.trimToEmpty((String)distributed));
        if (distributedCachingEnabled) {
            String entityCacheDistributed = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ENTITYCACHE_DISTRIBUTED);
            return Boolean.valueOf(StringUtils.trimToEmpty((String)entityCacheDistributed));
        }
        return false;
    }

    @Override
    protected boolean handleIsTableRequired() {
        return !this.isHibernateInheritanceClass() || this.isHibernateInheritanceClass() && this.getGeneralization() == null;
    }

    @Override
    protected String handleGetMappingClassName() {
        String mappingClassName = "class";
        HibernateEntity superEntity = this.getSuperEntity();
        if (superEntity != null && !superEntity.isHibernateInheritanceInterface() && !superEntity.isHibernateInheritanceConcrete()) {
            mappingClassName = JOINED_SUBCLASS_MAPPING_NAME;
            if (this.isHibernateInheritanceClass()) {
                mappingClassName = "subclass";
            } else if (this.isHibernateInheritanceUnionSubClass()) {
                mappingClassName = "union-subclass";
            }
        }
        return mappingClassName;
    }

    private HibernateEntity getSuperEntity() {
        HibernateEntity superEntity = null;
        if (this.getGeneralization() != null && this.getGeneralization() instanceof HibernateEntity) {
            superEntity = (HibernateEntity)this.getGeneralization();
        }
        return superEntity;
    }

    @Override
    protected String handleGetSubclassKeyColumn() {
        ModelElementFacade facade;
        String column = null;
        HibernateEntity superEntity = this.getSuperEntity();
        if (superEntity != null && superEntity.isHibernateInheritanceSubclass() && (facade = (ModelElementFacade)this.getIdentifiers().iterator().next()) instanceof EntityAttribute) {
            column = ((EntityAttribute)facade).getColumnName();
        }
        return column;
    }

    @Override
    protected boolean handleIsRequiresMapping() {
        HibernateEntity superEntity = this.getSuperEntity();
        return HibernateUtils.mapSubclassesInSeparateFile((String)this.getConfiguredProperty("hibernateMappingStrategy")) || this.isRoot() && (!this.isHibernateInheritanceInterface() || this.getSpecializations().isEmpty() || superEntity != null && superEntity.isHibernateInheritanceInterface());
    }

    private boolean isRoot() {
        HibernateEntity superEntity = this.getSuperEntity();
        boolean abstractConcreteEntity = (this.isHibernateInheritanceConcrete() || this.isHibernateInheritanceInterface()) && this.isAbstract();
        return (this.getSuperEntity() == null || superEntity.isHibernateInheritanceInterface() || superEntity.isHibernateInheritanceConcrete()) && !abstractConcreteEntity;
    }

    @Override
    protected boolean handleIsRequiresSpecializationMapping() {
        return !HibernateUtils.mapSubclassesInSeparateFile((String)this.getConfiguredProperty("hibernateMappingStrategy")) && this.isRoot() && (this.isHibernateInheritanceSubclass() || this.isHibernateInheritanceClass() || this.isHibernateInheritanceUnionSubClass());
    }

    @Override
    protected boolean handleIsDynamicInsert() {
        String dynamicInsert = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ENTITY_DYNAMIC_INSERT);
        if (StringUtils.isBlank((String)dynamicInsert)) {
            dynamicInsert = (String)this.getConfiguredProperty("hibernateEntityDynamicInsert");
        }
        return Boolean.valueOf(dynamicInsert);
    }

    @Override
    protected boolean handleIsDynamicUpdate() {
        String dynamicUpdate = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ENTITY_DYNAMIC_UPDATE);
        if (StringUtils.isBlank((String)dynamicUpdate)) {
            dynamicUpdate = (String)this.getConfiguredProperty("hibernateEntityDynamicUpdate");
        }
        return Boolean.valueOf(dynamicUpdate);
    }

    @Override
    protected boolean handleIsMappingRequiresSuperProperties() {
        return this.isHibernateInheritanceInterface() || this.isHibernateInheritanceConcrete() && this.isAbstract();
    }

    @Override
    protected String handleGetHibernateVersionProperty() {
        String version = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_VERSION_PROPERTY);
        if (StringUtils.isBlank((String)version)) {
            version = (String)this.getConfiguredProperty("versionProperty");
        }
        return version;
    }

    @Override
    protected String handleGetHibernateVersionPropertySqlName() {
        return EntityMetafacadeUtils.toSqlName((String)this.getHibernateVersionProperty(), (Object)this.getConfiguredProperty("sqlNameSeparator"));
    }

    @Override
    protected int handleGetVersion() {
        String version = (String)this.getConfiguredProperty("hibernateVersion");
        version = version == null ? "3" : version.substring(0, 1);
        return Integer.parseInt(version);
    }

    private boolean isXmlPersistenceActive() {
        return HibernateUtils.isXmlPersistenceActive((String)this.getConfiguredProperty("hibernateVersion"), (String)this.getConfiguredProperty("hibernateXMLPersistence"));
    }

    @Override
    protected String handleGetXmlTagName() {
        String tagName = null;
        if (this.isXmlPersistenceActive() && StringUtils.isBlank((String)(tagName = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_XML_TAG_NAME)))) {
            tagName = this.getName();
        }
        return StringUtils.isBlank(tagName) ? null : tagName;
    }

    @Override
    protected String handleGetHibernateDiscriminatorValue() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_ENTITY_DISCRIMINATOR_VALUE);
        if (StringUtils.isBlank((String)value)) {
            value = this.getEntityImplementationName();
        }
        return value;
    }

    @Override
    protected String handleGetSequenceName() {
        String sequenceName = this.getTableName();
        String sequenceSuffix = this.getSequenceSuffix();
        int maxLength = this.getMaxSqlNameLength() - this.getSequenceSuffix().length();
        if (maxLength > 0) {
            sequenceName = EntityMetafacadeUtils.ensureMaximumNameLength((String)sequenceName, (Short)Integer.valueOf(maxLength).shortValue()) + sequenceSuffix;
        }
        return sequenceName;
    }

    private String getSequenceSuffix() {
        return ObjectUtils.toString((Object)this.getConfiguredProperty(SEQUENCE_IDENTIFIER_SUFFIX));
    }

    static {
        inheritanceStrategies.add("class");
        inheritanceStrategies.add("subclass");
        inheritanceStrategies.add(INHERITANCE_STRATEGY_CONCRETE);
        inheritanceStrategies.add(INHERITANCE_STRATEGY_INTERFACE);
        inheritanceStrategies.add("union-subclass");
    }
}

