/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.listeners.utils;

import java.util.ArrayList;
import java.util.List;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.local.destination.notification.NotificationProxy;
import net.timewalker.ffmq4.transport.PacketTransport;
import net.timewalker.ffmq4.transport.packet.AbstractPacket;
import net.timewalker.ffmq4.transport.packet.NotificationPacket;
import net.timewalker.ffmq4.utils.id.IntegerID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RemoteNotificationProxy
implements NotificationProxy {
    private static final Log log = LogFactory.getLog(RemoteNotificationProxy.class);
    private PacketTransport transport;
    private IntegerID sessionId;
    private List<NotificationPacket> notificationBuffer = new ArrayList<NotificationPacket>();

    public RemoteNotificationProxy(IntegerID sessionId, PacketTransport transport) {
        this.sessionId = sessionId;
        this.transport = transport;
    }

    public synchronized void addNotification(IntegerID consumerId, AbstractMessage prefetchedMessage) {
        NotificationPacket notifPacket = new NotificationPacket();
        notifPacket.setSessionId(this.sessionId);
        notifPacket.setConsumerId(consumerId);
        notifPacket.setMessage(prefetchedMessage);
        notifPacket.setDonePrefetching(true);
        for (int i = this.notificationBuffer.size() - 1; i >= 0; --i) {
            NotificationPacket previousNotifPacket = this.notificationBuffer.get(i);
            if (!previousNotifPacket.getConsumerId().equals((Object)consumerId)) continue;
            previousNotifPacket.setDonePrefetching(false);
            break;
        }
        this.notificationBuffer.add(notifPacket);
    }

    public synchronized void flush() {
        if (!this.transport.isClosed()) {
            try {
                int len = this.notificationBuffer.size();
                for (int i = 0; i < len; ++i) {
                    NotificationPacket notifPacket = this.notificationBuffer.get(i);
                    this.transport.send((AbstractPacket)notifPacket);
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not send notification packet", (Throwable)e);
                this.transport.close();
            }
        }
        this.notificationBuffer.clear();
    }
}

