/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.jmx.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.server.RMIServerSocketFactory;
import java.util.List;
import java.util.Vector;
import javax.net.ServerSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JMXOverRMIServerSocketFactory
implements RMIServerSocketFactory {
    private static final Log log = LogFactory.getLog(JMXOverRMIServerSocketFactory.class);
    private String listenAddr;
    private int backLog;
    private boolean manageSockets;
    private InetAddress listenIf;
    private ServerSocketFactory socketFactory;
    private List<ServerSocket> createdSockets = new Vector<ServerSocket>();

    public JMXOverRMIServerSocketFactory(int backLog, String listenAddr, boolean manageSockets) {
        this.backLog = backLog;
        this.listenAddr = listenAddr;
        this.manageSockets = manageSockets;
    }

    private synchronized ServerSocketFactory getSocketFactory() {
        if (this.socketFactory == null) {
            this.socketFactory = ServerSocketFactory.getDefault();
        }
        return this.socketFactory;
    }

    private synchronized InetAddress getListenAddress() throws UnknownHostException {
        if (this.listenIf == null) {
            this.listenIf = InetAddress.getByName(this.listenAddr);
        }
        return this.listenIf;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket socket = this.getSocketFactory().createServerSocket(port, this.backLog, this.getListenAddress());
        if (this.manageSockets) {
            this.createdSockets.add(socket);
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.manageSockets) {
            throw new IllegalStateException("Cannot close an un-managed socket factory");
        }
        List<ServerSocket> list = this.createdSockets;
        synchronized (list) {
            for (ServerSocket socket : this.createdSockets) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    log.error((Object)"Could not close server socket", (Throwable)e);
                }
            }
            this.createdSockets.clear();
        }
    }
}

