/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;
import org.semanticweb.owlapi.util.RootClassChecker;

public class SimpleRootClassChecker
implements RootClassChecker {
    private final Set<OWLOntology> ontologies;
    private final RootClassCheckerHelper checker = new RootClassCheckerHelper();
    protected final NamedSuperChecker superChecker = new NamedSuperChecker();

    public SimpleRootClassChecker(Set<OWLOntology> ontologies) {
        this.ontologies = ontologies;
    }

    @Override
    public boolean isRootClass(OWLClass cls) {
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getReferencingAxioms(cls)) {
                this.checker.setOWLClass(cls);
                ax.accept(this.checker);
                if (this.checker.isRoot()) continue;
                return false;
            }
        }
        return true;
    }

    private class RootClassCheckerHelper
    extends OWLAxiomVisitorAdapter {
        private boolean isRoot;
        private OWLClass cls;

        public void setOWLClass(OWLClass cls) {
            this.isRoot = true;
            this.cls = cls;
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (axiom.getSubClass().equals(this.cls)) {
                SimpleRootClassChecker.this.superChecker.reset();
                axiom.getSuperClass().accept(SimpleRootClassChecker.this.superChecker);
                this.isRoot = !SimpleRootClassChecker.this.superChecker.namedSuper;
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            Set<OWLClassExpression> descs = axiom.getClassExpressions();
            if (!descs.contains(this.cls)) {
                return;
            }
            for (OWLClassExpression desc : descs) {
                if (desc.equals(this.cls)) continue;
                SimpleRootClassChecker.this.superChecker.reset();
                desc.accept(SimpleRootClassChecker.this.superChecker);
                if (!SimpleRootClassChecker.this.superChecker.namedSuper) continue;
                this.isRoot = false;
                return;
            }
            this.isRoot = !SimpleRootClassChecker.this.superChecker.namedSuper;
        }
    }

    private static class NamedSuperChecker
    extends OWLClassExpressionVisitorAdapter {
        protected boolean namedSuper;

        public void reset() {
            this.namedSuper = false;
        }

        @Override
        public void visit(OWLClass desc) {
            this.namedSuper = true;
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression op : desc.getOperands()) {
                op.accept(this);
                if (!this.namedSuper) continue;
                break;
            }
        }
    }
}

