/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.util.WeakCache;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class IRI
implements OWLAnnotationSubject,
OWLAnnotationValue,
SWRLPredicate,
OWLPrimitive,
CharSequence {
    private static final long serialVersionUID = 30406L;
    private static WeakCache<String> prefixCache = new WeakCache();
    private final String remainder;
    private final String prefix;
    private int hashCode = 0;

    public URI toURI() {
        if (this.remainder != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.prefix);
            sb.append(this.remainder);
            return URI.create(sb.toString());
        }
        return URI.create(this.prefix);
    }

    public boolean isAbsolute() {
        int colonIndex = this.prefix.indexOf(58);
        if (colonIndex == -1) {
            return false;
        }
        for (int i = 0; i < colonIndex; ++i) {
            char ch = this.prefix.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '.' || ch == '+' || ch == '-') continue;
            return false;
        }
        return true;
    }

    public String getScheme() {
        int colonIndex = this.prefix.indexOf(58);
        if (colonIndex == -1) {
            return null;
        }
        return this.prefix.substring(0, colonIndex);
    }

    @Deprecated
    public String getStart() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.prefix;
    }

    public IRI resolve(String s) {
        URI uri = URI.create(s);
        if (uri.isAbsolute() || uri.isOpaque()) {
            return IRI.create(uri);
        }
        return IRI.create(this.toURI().resolve(uri).toString());
    }

    public boolean isReservedVocabulary() {
        return Namespaces.OWL.inNamespace(this.prefix) || Namespaces.RDF.inNamespace(this.prefix) || Namespaces.RDFS.inNamespace(this.prefix) || Namespaces.XSD.inNamespace(this.prefix);
    }

    public boolean isThing() {
        return this.remainder != null && this.remainder.equals("Thing") && Namespaces.OWL.inNamespace(this.prefix);
    }

    public boolean isNothing() {
        return this.equals(OWLRDFVocabulary.OWL_NOTHING.getIRI());
    }

    public boolean isPlainLiteral() {
        return this.remainder != null && this.remainder.equals("PlainLiteral") && Namespaces.RDF.inNamespace(this.prefix);
    }

    public String getFragment() {
        return this.remainder;
    }

    public String toQuotedString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.prefix);
        if (this.remainder != null) {
            sb.append(this.remainder);
        }
        sb.append(">");
        return sb.toString();
    }

    public static IRI create(String str) {
        if (str == null) {
            throw new NullPointerException("String must not be null");
        }
        int index = XMLUtils.getNCNameSuffixIndex(str);
        if (index < 0) {
            return new IRI(str, null);
        }
        return new IRI(str.substring(0, index), str.substring(index));
    }

    public static IRI create(String prefix, String suffix) {
        if (prefix == null) {
            return IRI.create(suffix);
        }
        if (suffix == null) {
            return IRI.create(prefix);
        }
        int index = XMLUtils.getNCNameSuffixIndex(prefix);
        int test = XMLUtils.getNCNameSuffixIndex(suffix);
        if (index == -1 && test == 0) {
            return new IRI(prefix, suffix);
        }
        return IRI.create(prefix + suffix);
    }

    public static IRI create(File file) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        return new IRI(file.toURI());
    }

    public static IRI create(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri cannot be null");
        }
        return new IRI(uri);
    }

    public static IRI create(URL url) throws URISyntaxException {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        return new IRI(url.toURI());
    }

    public static IRI generateDocumentIRI() {
        return IRI.create("owlapi:ontology" + System.nanoTime());
    }

    protected IRI(String prefix, String fragment) {
        this.prefix = prefixCache.cache(prefix);
        this.remainder = fragment;
    }

    protected IRI(String s) {
        this(XMLUtils.getNCNamePrefix(s), XMLUtils.getNCNameSuffix(s));
    }

    protected IRI(URI uri) {
        this(uri.toString());
    }

    @Override
    public int length() {
        return this.prefix.length() + (this.remainder == null ? 0 : this.remainder.length());
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index < this.prefix.length()) {
            return this.prefix.charAt(index);
        }
        return this.remainder.charAt(index - this.prefix.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix);
        sb.append(this.remainder);
        return sb.subSequence(start, end);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationSubjectVisitor visitor) {
        visitor.visit(this);
    }

    public <E> E accept(OWLAnnotationSubjectVisitorEx<E> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return Collections.emptySet();
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return false;
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLClassExpression> getNestedClassExpressions() {
        return Collections.emptySet();
    }

    @Override
    public int compareTo(OWLObject o) {
        if (o == this) {
            return 0;
        }
        if (!(o instanceof IRI)) {
            return -1;
        }
        IRI other = (IRI)o;
        int diff = this.prefix.compareTo(other.prefix);
        if (diff != 0) {
            return diff;
        }
        String otherRemainder = other.remainder;
        if (this.remainder == null) {
            if (otherRemainder == null) {
                return 0;
            }
            return -1;
        }
        if (otherRemainder == null) {
            return 1;
        }
        return this.remainder.compareTo(otherRemainder);
    }

    @Override
    public String toString() {
        if (this.remainder != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.prefix);
            sb.append(this.remainder);
            return sb.toString();
        }
        return this.prefix;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.prefix.hashCode() + (this.remainder != null ? this.remainder.hashCode() : 0);
        }
        return this.hashCode;
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isTopEntity() {
        return false;
    }

    @Override
    public boolean isBottomEntity() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IRI)) {
            return false;
        }
        IRI other = (IRI)obj;
        String otherRemainder = other.remainder;
        if (this.remainder == null) {
            return otherRemainder == null && this.prefix.equals(other.prefix);
        }
        return otherRemainder != null && this.remainder.equals(otherRemainder) && other.prefix.equals(this.prefix);
    }
}

