/*
 * Copyright 2007 Robert Hanson <iamroberthanson AT gmail.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gwtwidgets.client.ui.canvas.impl;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

/**
 * Support functions for canvas
 * @author George Georgovassilis g.georgovassilis[at]gmail.com
 *
 */
public class Utils {
	
	/**
	 * Return the width in pixels of an element
	 * @param e
	 * @return
	 */
	public native static int getWidth(Element e)/*-{
			return e.width;
			}-*/;

	/**
	 * Return the height in pixels of an element
	 * @param e
	 * @return
	 */
	public native static int getHeight(Element e)/*-{
			return e.height;
			}-*/;

	private static String[] makeArray(int size) {
		return new String[size];
	}

	private static void set(String[] array, int position, String value) {
		array[position] = value;
	}

	/**
	 * Faster version of {@link String#split(String)} suitable for large strings.
	 * @param text
	 * @param delimiter
	 * @return
	 */
	public native static String[] split(String text, String delimiter)/*-{
		var arr = text.split(delimiter);
		var sarr = @org.gwtwidgets.client.ui.canvas.impl.Utils::makeArray(I)(arr.length);
		for (var i = arr.length-1;i>=0;i--)
			@org.gwtwidgets.client.ui.canvas.impl.Utils::set([Ljava/lang/String;ILjava/lang/String;)(sarr,i,arr[i]);
		return sarr;
		}-*/;

	/**
	 * Converts a radix 26 representation of a string to an integer
	 * @param value
	 * @return
	 */
	public static int readInt(String value) {
		return Integer.parseInt(value, 26);
	}

	/**
	 * Applies the specified dimensions as style, element attributes and clipping on the
	 * provided element.
	 * @param e
	 * @param width
	 * @param height
	 */
	public static void applySize(Element e, int width, int height) {
		DOM.setStyleAttribute(e, "clip", "rect(0," + width + "," + height + "," + 0 + ")");
		DOM.setStyleAttribute(e, "overflow", "hidden");
		DOM.setElementAttribute(e, "width", width + "px");
		DOM.setElementAttribute(e, "height", height + "px");
	}
	
	/**
	 * Clones an array of doubles
	 * @param array
	 * @return
	 */
	public static double[] copy(double[] array){
		double[] clone = new double[array.length];
		for (int i=clone.length-1;i>=0;i--)
			clone[i] = array[i];
		return clone;
	} 

	/**
	 * Creates an image element and assigns the specified source
	 * @param src
	 * @return
	 */
	public static Element createImage(String src){
		Element image = DOM.createImg();
		DOM.setImgSrc(image, src);
		return image;
	}
	
}
