/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.semantic.io.json;

import it.tidalwave.semantic.io.json.impl.Literals;
import it.tidalwave.util.Id;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.json.me.JSONException;
import org.json.me.JSONWriter;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RdfJsonWriter
implements RDFWriter {
    @Nonnull
    private final JSONWriter jw;
    private Resource prevSubject = null;
    private URI prevPredicate = null;
    private final List<Value> objects = new ArrayList<Value>();

    public RdfJsonWriter(@Nonnull Writer w) {
        this.jw = new JSONWriter(w);
    }

    @Nonnull
    public RDFFormat getRDFFormat() {
        throw new UnsupportedOperationException();
    }

    public void startRDF() throws RDFHandlerException {
        try {
            this.jw.object();
        }
        catch (JSONException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void endRDF() throws RDFHandlerException {
        try {
            if (!this.objects.isEmpty()) {
                this.jw.key(this.prevPredicate.stringValue());
                this.marshalObjects(this.objects);
            }
            this.jw.endObject();
            this.jw.endObject();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        catch (JSONException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleNamespace(@Nonnull String string, @Nonnull String string1) throws RDFHandlerException {
    }

    public void handleStatement(@Nonnull Statement statement) throws RDFHandlerException {
        try {
            URI predicate;
            Resource subject = statement.getSubject();
            if (this.prevSubject == null || !this.prevSubject.equals(subject)) {
                if (this.prevSubject != null) {
                    if (!this.objects.isEmpty()) {
                        this.jw.key(this.prevPredicate.stringValue());
                        this.marshalObjects(this.objects);
                    }
                    this.jw.endObject();
                }
                this.jw.key(subject.stringValue()).object();
                this.prevSubject = subject;
                this.objects.clear();
                this.prevPredicate = statement.getPredicate();
            }
            if (!(predicate = statement.getPredicate()).equals(this.prevPredicate)) {
                this.jw.key(this.prevPredicate.stringValue());
                this.marshalObjects(this.objects);
                this.objects.clear();
            }
            this.objects.add(statement.getObject());
            this.prevPredicate = predicate;
        }
        catch (JSONException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(@Nonnull String string) throws RDFHandlerException {
    }

    private void marshalObjects(@Nonnull Collection<Value> objects) throws IOException, JSONException {
        this.jw.array();
        for (Value object : objects) {
            if (object.getClass().getSimpleName().equals("UriImplWithAs")) {
                Literals.marshalReference(this.jw, new Id((Object)object.stringValue()));
                continue;
            }
            Literals.marshalLiteral(this.jw, object);
        }
        this.jw.endArray();
    }
}

