/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpHandler;
import brave.http.HttpRequest;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;

public final class HttpServerHandler<Req, Resp>
extends HttpHandler {
    final Tracer tracer;
    final SamplerFunction<HttpRequest> sampler;
    final TraceContext.Extractor<HttpServerRequest> defaultExtractor;

    public static HttpServerHandler<HttpServerRequest, HttpServerResponse> create(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        return new HttpServerHandler<HttpServerRequest, HttpServerResponse>(httpTracing);
    }

    HttpServerHandler(HttpTracing httpTracing) {
        super(httpTracing.serverRequestParser(), httpTracing.serverResponseParser());
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.serverRequestSampler();
        this.defaultExtractor = httpTracing.propagation().extractor(HttpServerRequest.GETTER);
    }

    public Span handleReceive(HttpServerRequest request) {
        Span span = this.nextSpan(this.defaultExtractor.extract((Object)request), request);
        return this.handleStart(request, span);
    }

    @Override
    void parseRequest(HttpRequest request, Span span) {
        ((HttpServerRequest)request).parseClientIpAndPort(span);
        super.parseRequest(request, span);
    }

    Span nextSpan(TraceContextOrSamplingFlags extracted, HttpServerRequest request) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = this.sampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
    }

    public void handleSend(HttpServerResponse response, Span span) {
        this.handleFinish(response, span);
    }
}

