/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.core.impl.NoStackTraceThrowable;
import java.util.List;
import java.util.Objects;

public class SMTPException
extends NoStackTraceThrowable {
    private final int replyCode;
    private final List<String> replyMessages;
    private final EnhancedStatus enhancedStatus;

    public SMTPException(String message, int replyCode, List<String> replyMessages, boolean supportEnhancementStatusCode) {
        super(message + ": " + String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)Objects.requireNonNull(replyMessages)));
        this.replyCode = replyCode;
        this.replyMessages = replyMessages;
        if (supportEnhancementStatusCode) {
            int detail;
            int subject;
            try {
                String line = replyMessages.get(0).substring(4);
                String statusStr = line.substring(0, line.indexOf(" "));
                subject = Integer.parseInt(statusStr.substring(statusStr.indexOf(".") + 1, statusStr.lastIndexOf(".")));
                detail = Integer.parseInt(statusStr.substring(statusStr.lastIndexOf(".") + 1));
            }
            catch (Exception e) {
                subject = -1;
                detail = 0;
            }
            this.enhancedStatus = EnhancedStatus.fromSubject(subject);
            this.enhancedStatus.setDetail(detail);
        } else {
            this.enhancedStatus = EnhancedStatus.OTHER_UNKNOWN;
        }
    }

    public int getReplyCode() {
        return this.replyCode;
    }

    public List<String> getReplyMessages() {
        return this.replyMessages;
    }

    public String getReplyMessage() {
        return this.replyMessages.get(0);
    }

    public boolean isPermanent() {
        return this.replyCode >= 500;
    }

    public boolean isTransient() {
        return this.replyCode >= 400 && this.replyCode < 500;
    }

    public EnhancedStatus getEnhancedStatus() {
        return this.enhancedStatus;
    }

    public static enum EnhancedStatus {
        OTHER_UNDEFINED(0),
        OTHER_ADDRESS(1),
        OTHER_MAILBOX(2),
        OTHER_MAIL_SYSTEM(3),
        OTHER_NETWORK(4),
        OTHER_MAIL_DELIVERY(5),
        OTHER_MAIL_MESSAGE(6),
        OTHER_SECURITY(7),
        OTHER_UNKNOWN(-1);

        private final int subject;
        private int detail;

        private EnhancedStatus(int subject) {
            this.subject = subject;
        }

        public int getSubject() {
            return this.subject;
        }

        public int getDetail() {
            return this.detail;
        }

        private void setDetail(int detail) {
            this.detail = detail;
        }

        static EnhancedStatus fromSubject(int subject) {
            if (subject >= 0 && subject < EnhancedStatus.values().length) {
                return EnhancedStatus.values()[subject];
            }
            return OTHER_UNKNOWN;
        }
    }
}

