/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.handler.logging.ByteBufFormat;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptionsConverter;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public class NetClientOptions
extends ClientOptionsBase {
    public static final int DEFAULT_RECONNECT_ATTEMPTS = 0;
    public static final long DEFAULT_RECONNECT_INTERVAL = 1000L;
    public static final String DEFAULT_HOSTNAME_VERIFICATION_ALGORITHM = null;
    public static final boolean DEFAULT_REGISTER_WRITE_HANDLER = false;
    private int reconnectAttempts;
    private long reconnectInterval;
    private String hostnameVerificationAlgorithm;
    private List<String> applicationLayerProtocols;
    private boolean registerWriteHandler;

    public NetClientOptions() {
        this.init();
    }

    public NetClientOptions(NetClientOptions other) {
        super(other);
        this.reconnectAttempts = other.getReconnectAttempts();
        this.reconnectInterval = other.getReconnectInterval();
        this.hostnameVerificationAlgorithm = other.getHostnameVerificationAlgorithm();
        this.applicationLayerProtocols = other.applicationLayerProtocols != null ? new ArrayList<String>(other.applicationLayerProtocols) : null;
        this.registerWriteHandler = other.registerWriteHandler;
    }

    public NetClientOptions(ClientOptionsBase other) {
        super(other);
    }

    public NetClientOptions(JsonObject json) {
        super(json);
        this.init();
        NetClientOptionsConverter.fromJson(json, this);
    }

    private void init() {
        this.reconnectAttempts = 0;
        this.reconnectInterval = 1000L;
        this.hostnameVerificationAlgorithm = DEFAULT_HOSTNAME_VERIFICATION_ALGORITHM;
        this.registerWriteHandler = false;
    }

    @Override
    public NetClientOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public NetClientOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public NetClientOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public NetClientOptions setReusePort(boolean reusePort) {
        super.setReusePort(reusePort);
        return this;
    }

    @Override
    public NetClientOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetClientOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetClientOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public NetClientOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public NetClientOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public NetClientOptions setReadIdleTimeout(int idleTimeout) {
        super.setReadIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public NetClientOptions setWriteIdleTimeout(int idleTimeout) {
        super.setWriteIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public NetClientOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        super.setIdleTimeoutUnit(idleTimeoutUnit);
        return this;
    }

    @Override
    public NetClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public NetClientOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    @Override
    @Deprecated
    public NetClientOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    @Override
    @Deprecated
    public NetClientOptions setPfxKeyCertOptions(PfxOptions options) {
        return (NetClientOptions)super.setPfxKeyCertOptions(options);
    }

    @Override
    @Deprecated
    public NetClientOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (NetClientOptions)super.setPemKeyCertOptions(options);
    }

    @Override
    public NetClientOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    @Override
    @Deprecated
    public NetClientOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    @Override
    @Deprecated
    public NetClientOptions setPemTrustOptions(PemTrustOptions options) {
        return (NetClientOptions)super.setPemTrustOptions(options);
    }

    @Override
    @Deprecated
    public NetClientOptions setPfxTrustOptions(PfxOptions options) {
        return (NetClientOptions)super.setPfxTrustOptions(options);
    }

    @Override
    public NetClientOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public NetClientOptions removeEnabledCipherSuite(String suite) {
        super.removeEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public NetClientOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    @Override
    public NetClientOptions removeEnabledSecureTransportProtocol(String protocol) {
        return (NetClientOptions)super.removeEnabledSecureTransportProtocol(protocol);
    }

    @Override
    public NetClientOptions setUseAlpn(boolean useAlpn) {
        return (NetClientOptions)super.setUseAlpn(useAlpn);
    }

    @Override
    public NetClientOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (NetClientOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    @Deprecated
    public NetClientOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (NetClientOptions)super.setJdkSslEngineOptions(sslEngineOptions);
    }

    @Override
    public NetClientOptions setTcpFastOpen(boolean tcpFastOpen) {
        return (NetClientOptions)super.setTcpFastOpen(tcpFastOpen);
    }

    @Override
    public NetClientOptions setTcpCork(boolean tcpCork) {
        return (NetClientOptions)super.setTcpCork(tcpCork);
    }

    @Override
    public NetClientOptions setTcpQuickAck(boolean tcpQuickAck) {
        return (NetClientOptions)super.setTcpQuickAck(tcpQuickAck);
    }

    @Override
    public NetClientOptions setTcpUserTimeout(int tcpUserTimeout) {
        return (NetClientOptions)super.setTcpUserTimeout(tcpUserTimeout);
    }

    @Override
    @Deprecated
    public ClientOptionsBase setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return super.setOpenSslEngineOptions(sslEngineOptions);
    }

    @Override
    public NetClientOptions addCrlPath(String crlPath) throws NullPointerException {
        return (NetClientOptions)super.addCrlPath(crlPath);
    }

    @Override
    public NetClientOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (NetClientOptions)super.addCrlValue(crlValue);
    }

    @Override
    public NetClientOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    @Override
    public NetClientOptions setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public NetClientOptions setMetricsName(String metricsName) {
        return (NetClientOptions)super.setMetricsName(metricsName);
    }

    public NetClientOptions setReconnectAttempts(int attempts) {
        if (attempts < -1) {
            throw new IllegalArgumentException("reconnect attempts must be >= -1");
        }
        this.reconnectAttempts = attempts;
        return this;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public NetClientOptions setReconnectInterval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("reconnect interval must be >= 1");
        }
        this.reconnectInterval = interval;
        return this;
    }

    public String getHostnameVerificationAlgorithm() {
        return this.hostnameVerificationAlgorithm;
    }

    public NetClientOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        Objects.requireNonNull(hostnameVerificationAlgorithm, "hostnameVerificationAlgorithm can not be null!");
        this.hostnameVerificationAlgorithm = hostnameVerificationAlgorithm;
        return this;
    }

    public List<String> getApplicationLayerProtocols() {
        return this.applicationLayerProtocols;
    }

    public NetClientOptions setApplicationLayerProtocols(List<String> protocols) {
        this.applicationLayerProtocols = protocols;
        return this;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public NetClientOptions setLogActivity(boolean logEnabled) {
        return (NetClientOptions)super.setLogActivity(logEnabled);
    }

    @Override
    public NetClientOptions setActivityLogDataFormat(ByteBufFormat activityLogDataFormat) {
        return (NetClientOptions)super.setActivityLogDataFormat(activityLogDataFormat);
    }

    @Override
    public NetClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        return (NetClientOptions)super.setProxyOptions(proxyOptions);
    }

    @Override
    public NetClientOptions setNonProxyHosts(List<String> nonProxyHosts) {
        return (NetClientOptions)super.setNonProxyHosts(nonProxyHosts);
    }

    @Override
    public NetClientOptions addNonProxyHost(String nonProxyHost) {
        return (NetClientOptions)super.addNonProxyHost(nonProxyHost);
    }

    @Override
    public NetClientOptions setLocalAddress(String localAddress) {
        return (NetClientOptions)super.setLocalAddress(localAddress);
    }

    @Override
    public NetClientOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        return (NetClientOptions)super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    @Override
    public NetClientOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        return (NetClientOptions)super.setSslHandshakeTimeout(sslHandshakeTimeout);
    }

    @Override
    public NetClientOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        return (NetClientOptions)super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        NetClientOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isRegisterWriteHandler() {
        return this.registerWriteHandler;
    }

    public NetClientOptions setRegisterWriteHandler(boolean registerWriteHandler) {
        this.registerWriteHandler = registerWriteHandler;
        return this;
    }
}

