/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.opensymphony.xwork2.util.DomHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.impl.I18nParseXmlMojoSupport;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.MirroredFileUpdater;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Mojo(name="parse-validation-fields", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ParseValidationFieldsMojo
extends I18nParseXmlMojoSupport {
    public static final String DEFAULT_INCLUDES = "**/*-validation.xml";
    @Parameter(property="i18n.defaultBasedir", defaultValue="${basedir}/src/main/resources", required=true)
    private File defaultBasedir;
    @Parameter(property="i18n.defaultIncludes", defaultValue="**/*-validation.xml", required=true)
    private String defaultIncludes;
    @Parameter(property="i18n.useLocalResolver", defaultValue="true")
    private boolean useLocalResolver;
    @Parameter(property="i18n.outputGetter", defaultValue="validation-fields.getter", required=true)
    private String outputGetter;
    private Map<String, String> dtdMappings = new HashMap<String, String>();
    @Parameter(property="i18n.validationFieldPrefix", required=true)
    private String validationFieldPrefix;
    @Parameter
    private Map<String, String> inheritanceMapping;
    private Set<Class<?>> inheritanceTypes;
    private Multimap<Class<?>, String> inheritanceRealMapping;
    private ClassLoader classLoader;

    public ParseValidationFieldsMojo() {
        this.dtdMappings.put("-//Apache Struts//XWork Validator 1.0//EN", "xwork-validator-1.0.dtd");
        this.dtdMappings.put("-//Apache Struts//XWork Validator 1.0.2//EN", "xwork-validator-1.0.2.dtd");
        this.dtdMappings.put("-//Apache Struts//XWork Validator 1.0.3//EN", "xwork-validator-1.0.3.dtd");
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.classLoader = this.initClassLoader(this.getProject(), this.buildOutputDirectory, false, false, false, true, true);
        this.inheritanceRealMapping = HashMultimap.create();
        if (this.inheritanceMapping != null) {
            for (Map.Entry<String, String> entry : this.inheritanceMapping.entrySet()) {
                Class<?> aClass = this.classLoader.loadClass(entry.getKey());
                for (String fieldName : entry.getValue().split(",")) {
                    this.inheritanceRealMapping.put(aClass, (Object)fieldName);
                }
            }
        }
        this.inheritanceTypes = this.inheritanceRealMapping.keySet();
    }

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return new MirroredFileUpdater("", "", entry.getBasedir(), this.buildOutputDirectory){

            public File getMirrorFile(File f) {
                String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
                return new File(this.destinationDirectory + File.separator + file);
            }
        };
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    protected String getCoreRuleFile() {
        return "validation-fields.rules";
    }

    @Override
    protected I18nParseXmlMojoSupport.XmlFileParser newXmlFileParser(final File basedir, XPath xpath, DocumentBuilder builder) {
        return new I18nParseXmlMojoSupport.XmlFileParser(this.getLog(), this.encoding, this.getAcceptPattern(), this.rules, xpath, builder, this.namespaces, this.isVerbose()){
            private final Path rootDirectory;
            private final Map<File, Class> fileTypeMapping;
            {
                super(log, encoding, acceptKeyPattern, rules, xpath, builder, namespaces, verbose);
                this.rootDirectory = basedir.toPath();
                this.fileTypeMapping = new TreeMap<File, Class>();
            }

            @Override
            protected Document fileToDocument(File fileToProcess) throws SAXException, IOException {
                InputSource in = new InputSource(FileUtils.openInputStream((File)fileToProcess));
                return DomHelper.parse((InputSource)in, (Map)ParseValidationFieldsMojo.this.dtdMappings);
            }

            @Override
            public String extract(File file, String i18nString) {
                Class type = this.getFileType(file);
                for (Class aClass : ParseValidationFieldsMojo.this.inheritanceTypes) {
                    if (!aClass.isAssignableFrom(type) || !ParseValidationFieldsMojo.this.inheritanceRealMapping.containsEntry((Object)aClass, (Object)i18nString)) continue;
                    type = aClass;
                    break;
                }
                String i18nKey = ParseValidationFieldsMojo.this.validationFieldPrefix + type.getSimpleName() + "." + i18nString.trim();
                if (ParseValidationFieldsMojo.this.isVerbose()) {
                    this.getLog().info((CharSequence)String.format("%s = %s", i18nString, i18nKey));
                }
                return i18nKey;
            }

            private Class getFileType(File file) {
                Class<?> type = this.fileTypeMapping.get(file);
                if (type == null) {
                    Path relativePath = this.rootDirectory.relativize(file.toPath());
                    StringBuilder fullyQualifiedNameBuilder = new StringBuilder();
                    for (Path path : relativePath) {
                        fullyQualifiedNameBuilder.append(".").append(path.getName(0));
                    }
                    String fullyQualifiedName = fullyQualifiedNameBuilder.substring(1);
                    int lastIndex = fullyQualifiedName.indexOf("-");
                    fullyQualifiedName = fullyQualifiedName.substring(0, lastIndex);
                    try {
                        type = ParseValidationFieldsMojo.this.classLoader.loadClass(fullyQualifiedName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Can't find type: " + fullyQualifiedName);
                    }
                    this.fileTypeMapping.put(file, type);
                }
                return type;
            }
        };
    }
}

