/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.plugin.bundle.BundleValidation;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.Plugin;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginWithEncoding;

public abstract class I18nMojoSupport
extends AbstractPlugin
implements PluginWithEncoding {
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="i18n.bundles", defaultValue="fr_FR,en_GB", required=true)
    protected String bundles;
    @Parameter(property="i18n.encoding", defaultValue="${project.build.sourceEncoding}", required=true)
    protected String encoding;
    @Parameter(property="i18n.artifactId", defaultValue="${project.artifactId}", readonly=true)
    protected String artifactId;
    @Parameter(property="i18n.sourceDirectory", defaultValue="${basedir}/src/main/resources/i18n", required=true)
    protected File sourceDirectory;
    @Parameter(property="i18n.buildOutputDirectory", defaultValue="${project.build.outputDirectory}")
    protected File buildOutputDirectory;
    @Parameter(property="i18n.gettersDirectory", defaultValue="${project.build.directory}/i18n/getters", required=true)
    protected File gettersDirectory;
    @Parameter(property="i18n.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="i18n.silent", defaultValue="false")
    protected boolean silent;
    protected Locale[] locales;
    protected Charset charset;

    protected boolean checkPackaging() {
        return !this.acceptPackaging(new Plugin.Packaging[]{Plugin.Packaging.pom});
    }

    public void init() throws Exception {
        this.charset = Charset.forName(this.encoding);
        if (this.verbose) {
            this.silent = false;
            this.getLog().info((CharSequence)"config - verbose mode is on");
        }
        this.locales = I18nUtil.parseLocales((String)this.bundles);
        if (this.locales.length == 0) {
            throw new IllegalStateException("You need at least one locale, please fill the 'bundles' property.");
        }
    }

    protected void checkBundle(Locale locale, Properties propertiesOut, boolean showEmpty, BundleValidation bundleValidation) {
        SortedSet emptyEntries = PluginHelper.getEmptyKeys((Map)propertiesOut);
        if (!emptyEntries.isEmpty()) {
            if (bundleValidation != null) {
                Map<Locale, SortedSet<String>> unsafeHolder = bundleValidation.getKeysMissingValues();
                SortedSet empties = unsafeHolder.computeIfAbsent(locale, k -> new TreeSet());
                empties.addAll(emptyEntries);
            }
            StringBuilder buffer = new StringBuilder();
            int size = emptyEntries.size();
            buffer.append("bundle ");
            buffer.append(locale);
            buffer.append(" contains ");
            buffer.append(size);
            buffer.append("/");
            buffer.append(propertiesOut.size());
            buffer.append(" empty entries!");
            if (showEmpty) {
                int index = 0;
                for (String key : emptyEntries) {
                    buffer.append("\n  - ");
                    buffer.append(index++);
                    buffer.append("/");
                    buffer.append(size);
                    buffer.append(" : ");
                    buffer.append(key);
                }
            } else {
                buffer.append(" (use -Di18n.showEmpty to see these entries)");
            }
            this.getLog().warn((CharSequence)buffer.toString());
        } else if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)String.format("bundle %s is valid (no empty entries).", locale));
        }
    }

    public File getBackupFile(File file) {
        return new File(file.getAbsolutePath() + "~");
    }

    protected void backupFile(File f) throws IOException {
        File dst = this.getBackupFile(f);
        this.copyFile(f, dst);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void failsIfAnyKeyMissingValue(boolean failsIfWarning, BundleValidation bundleValidation) throws MojoFailureException {
        if (!failsIfWarning) {
            return;
        }
        if (bundleValidation != null && bundleValidation.isAnyKeyMissingValue()) {
            throw new MojoFailureException(String.format("Bundles for locale(s) %s are not complete. Use the -Di18n.showEmpty to see missing translations.", bundleValidation.getKeysMissingValues().keySet()));
        }
    }

    protected void failsIfAnyKeyMissingInBundle(boolean failsIfWarning, BundleValidation bundleValidation) throws MojoFailureException {
        if (!failsIfWarning) {
            return;
        }
        if (bundleValidation != null && bundleValidation.isAnyKeyMissingInBundle()) {
            throw new MojoFailureException(String.format("Bundles for locale(s) %s are not complete. Use the -Di18n.showEmpty to see missing keys.", bundleValidation.getMissingKeysPerLocale().keySet()));
        }
    }

    protected File getI18nFile(File root, String artifactId, Locale locale, boolean create) throws IOException {
        String path = root.getAbsolutePath() + File.separatorChar + artifactId;
        if (locale != null) {
            path = path + "_" + locale.toString();
        }
        path = path + ".properties";
        File file = new File(path);
        if (create && !file.exists()) {
            PluginHelper.createNewFile((File)file);
        }
        return file;
    }
}

