/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.service.DocumentationPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

public class Orderings {
    private Orderings() {
        throw new UnsupportedOperationException();
    }

    public static Comparator<Operation> nickNameComparator() {
        return new Comparator<Operation>(){

            @Override
            public int compare(Operation first, Operation second) {
                return Strings.nullToEmpty((String)first.getUniqueId()).compareTo(Strings.nullToEmpty((String)second.getUniqueId()));
            }
        };
    }

    public static Comparator<Operation> positionComparator() {
        return new Comparator<Operation>(){

            @Override
            public int compare(Operation first, Operation second) {
                return Ints.compare((int)first.getPosition(), (int)second.getPosition());
            }
        };
    }

    public static Comparator<ApiListingReference> listingReferencePathComparator() {
        return new Comparator<ApiListingReference>(){

            @Override
            public int compare(ApiListingReference first, ApiListingReference second) {
                return first.getPath().compareTo(second.getPath());
            }
        };
    }

    public static Comparator<ApiListingReference> listingPositionComparator() {
        return new Comparator<ApiListingReference>(){

            @Override
            public int compare(ApiListingReference first, ApiListingReference second) {
                return Ints.compare((int)first.getPosition(), (int)second.getPosition());
            }
        };
    }

    public static Comparator<ApiDescription> apiPathCompatator() {
        return new Comparator<ApiDescription>(){

            @Override
            public int compare(ApiDescription first, ApiDescription second) {
                return first.getPath().compareTo(second.getPath());
            }
        };
    }

    public static Comparator<ResourceGroup> resourceGroupComparator() {
        return new Comparator<ResourceGroup>(){

            @Override
            public int compare(ResourceGroup first, ResourceGroup second) {
                return first.getGroupName().compareTo(second.getGroupName());
            }
        };
    }

    public static Comparator<RequestMappingContext> methodComparator() {
        return new Comparator<RequestMappingContext>(){

            @Override
            public int compare(RequestMappingContext first, RequestMappingContext second) {
                return Orderings.qualifiedMethodName(first).compareTo(Orderings.qualifiedMethodName(second));
            }
        };
    }

    private static String qualifiedMethodName(RequestMappingContext context) {
        return String.format("%s.%s", context.getGroupName(), context.getName());
    }

    public static Ordering<RequestHandler> byPatternsCondition() {
        return Ordering.from((Comparator)new Comparator<RequestHandler>(){

            @Override
            public int compare(RequestHandler first, RequestHandler second) {
                return Orderings.patternsCondition(first).toString().compareTo(Orderings.patternsCondition(second).toString());
            }
        });
    }

    static PatternsRequestCondition patternsCondition(RequestHandler handler) {
        return handler.getPatternsCondition();
    }

    public static Ordering<? super DocumentationPlugin> pluginOrdering() {
        return Ordering.from(Orderings.byPluginType()).compound(Orderings.byPluginName());
    }

    public static Comparator<? super DocumentationPlugin> byPluginType() {
        return new Comparator<DocumentationPlugin>(){

            @Override
            public int compare(DocumentationPlugin first, DocumentationPlugin second) {
                return Ints.compare((int)first.getDocumentationType().hashCode(), (int)second.getDocumentationType().hashCode());
            }
        };
    }

    public static Comparator<? super DocumentationPlugin> byPluginName() {
        return new Comparator<DocumentationPlugin>(){

            @Override
            public int compare(DocumentationPlugin first, DocumentationPlugin second) {
                return first.getGroupName().compareTo(second.getGroupName());
            }
        };
    }
}

