/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.codegen.AbstractMutinyGenerator;
import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

public class MutinyGenerator
extends AbstractMutinyGenerator {
    MutinyGenerator() {
        this.kinds = Collections.singleton("class");
        this.name = "mutiny";
    }

    @Override
    protected void genMethods(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        this.genMethod(model, method, cacheDecls, writer);
        MethodInfo publisherOverload = this.genOverloadedMethod(method, Publisher.class);
        if (publisherOverload != null) {
            this.genMethod(model, publisherOverload, cacheDecls, writer);
        }
    }

    @Override
    protected void genForgetMethods(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        this.genForgetMethod(false, model, method, cacheDecls, writer);
    }

    @Override
    protected void genConsumerMethodInfo(boolean decl, ClassModel model, MethodInfo method, PrintWriter writer) {
        MethodInfo futMethod = this.genConsumerMethodInfo(method);
        this.startMethodTemplate(false, futMethod.getName(), futMethod, new AbstractMutinyGenerator.MethodDescriptor("", false, false, false), writer);
        if (decl) {
            writer.println(";");
            return;
        }
        writer.println(" {");
        writer.print("    ");
        if (!method.getReturnType().isVoid()) {
            writer.print("return ");
        }
        writer.print("__" + method.getName() + "(");
        List params = futMethod.getParams();
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                writer.print(", ");
            }
            ParamInfo param = (ParamInfo)params.get(i);
            if (i < params.size() - 1) {
                writer.print(param.getName());
                continue;
            }
            writer.print(param.getName() + " != null ? " + param.getName() + "::accept : null");
        }
        writer.println(");");
        writer.println("  }");
        writer.println();
    }

    @Override
    protected void genUniMethod(boolean decl, ClassModel model, MethodInfo method, PrintWriter writer) {
        MethodInfo futMethod = this.genUniMethodInfo(method);
        ClassTypeInfo raw = futMethod.getReturnType().getRaw();
        String methodSimpleName = raw.getSimpleName();
        String adapterType = AsyncResultUni.class.getName() + ".to" + methodSimpleName;
        this.startMethodTemplate(false, futMethod.getName(), futMethod, new AbstractMutinyGenerator.MethodDescriptor("", false, false, true), writer);
        if (decl) {
            writer.println(";");
            return;
        }
        writer.println(" { ");
        writer.print("    return ");
        writer.print(adapterType);
        writer.println("(handler -> {");
        writer.print("      __");
        writer.print(method.getName());
        writer.print("(");
        List params = futMethod.getParams();
        writer.print(params.stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
        if (params.size() > 0) {
            writer.print(", ");
        }
        writer.println("handler);");
        writer.println("    });");
        writer.println("  }");
        writer.println();
    }

    @Override
    protected void genBlockingMethod(boolean decl, ClassModel model, MethodInfo method, PrintWriter writer) {
        MethodInfo blockingMethod = this.genBlockingMethodInfo(method);
        this.startMethodTemplate(false, blockingMethod.getName() + "AndAwait", blockingMethod, new AbstractMutinyGenerator.MethodDescriptor("", false, true, false), writer);
        if (decl) {
            writer.println(";");
            return;
        }
        writer.println(" { ");
        writer.print("    return (" + CodeGenHelper.genTypeName(blockingMethod.getReturnType()) + ") ");
        writer.print(blockingMethod.getName());
        writer.print("(");
        List params = blockingMethod.getParams();
        writer.print(params.stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
        writer.println(").await().indefinitely();");
        writer.println("  }");
        writer.println();
    }

    @Override
    public MethodInfo genConsumerMethodInfo(MethodInfo method) {
        ArrayList<ParamInfo> futParams = new ArrayList<ParamInfo>();
        int size = method.getParams().size() - 1;
        for (int count = 0; count < size; ++count) {
            ParamInfo param = method.getParam(count);
            futParams.add(param);
        }
        ParamInfo futParam = method.getParam(size);
        TypeInfo consumerType = ((ParameterizedTypeInfo)futParam.getType()).getArg(0);
        TypeInfo consumerUnresolvedType = ((ParameterizedTypeInfo)futParam.getUnresolvedType()).getArg(0);
        ParameterizedTypeInfo consumerReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Consumer.class).getRaw(), consumerUnresolvedType.isNullable(), Collections.singletonList(consumerType));
        futParams.add(new ParamInfo(futParams.size(), futParam.getName(), futParam.getDescription(), (TypeInfo)consumerReturnType));
        return method.copy().setParams(futParams);
    }

    private MethodInfo genUniMethodInfo(MethodInfo method) {
        ArrayList<ParamInfo> futParams = new ArrayList<ParamInfo>();
        int size = method.getParams().size() - 1;
        for (int count = 0; count < size; ++count) {
            ParamInfo param = method.getParam(count);
            futParams.add(param);
        }
        ParamInfo futParam = method.getParam(size);
        TypeInfo futType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getType()).getArg(0)).getArg(0);
        TypeInfo futUnresolvedType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getUnresolvedType()).getArg(0)).getArg(0);
        ParameterizedTypeInfo futReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Uni.class).getRaw(), futUnresolvedType.isNullable(), Collections.singletonList(futType));
        return method.copy().setReturnType((TypeInfo)futReturnType).setParams(futParams);
    }

    private MethodInfo genBlockingMethodInfo(MethodInfo method) {
        TypeInfo futType;
        ArrayList<ParamInfo> futParams = new ArrayList<ParamInfo>();
        int size = method.getParams().size() - 1;
        for (int count = 0; count < size; ++count) {
            ParamInfo param = method.getParam(count);
            futParams.add(param);
        }
        ParamInfo futParam = method.getParam(size);
        TypeInfo futReturnType = futType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getType()).getArg(0)).getArg(0);
        return method.copy().setReturnType(futReturnType).setParams(futParams);
    }

    private MethodInfo genOverloadedMethod(MethodInfo method, Class streamType) {
        ArrayList<ParamInfo> params = null;
        int count = 0;
        for (ParamInfo param : method.getParams()) {
            if (param.getType().isParameterized() && param.getType().getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                if (params == null) {
                    params = new ArrayList<ParamInfo>(method.getParams());
                }
                ParameterizedTypeInfo paramType = new ParameterizedTypeInfo(TypeReflectionFactory.create((Type)streamType).getRaw(), false, Collections.singletonList(((ParameterizedTypeInfo)param.getType()).getArg(0)));
                params.set(count, new ParamInfo(param.getIndex(), param.getName(), param.getDescription(), (TypeInfo)paramType));
            }
            ++count;
        }
        if (params != null) {
            return method.copy().setParams(params);
        }
        return null;
    }
}

