package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Handler that will timeout requests if the response has not been written after a certain time.
 * Timeout requests will be ended with an HTTP status code `503`.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.TimeoutHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.TimeoutHandler.class)
public class TimeoutHandler implements io.vertx.mutiny.ext.web.handler.PlatformHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<TimeoutHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new TimeoutHandler((io.vertx.ext.web.handler.TimeoutHandler) obj),
    TimeoutHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.TimeoutHandler delegate;
  
  public TimeoutHandler(io.vertx.ext.web.handler.TimeoutHandler delegate) {
    this.delegate = delegate;
  }

  public TimeoutHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.TimeoutHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  TimeoutHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.TimeoutHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TimeoutHandler that = (TimeoutHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.TimeoutHandler create() { 
    io.vertx.mutiny.ext.web.handler.TimeoutHandler ret = io.vertx.mutiny.ext.web.handler.TimeoutHandler.newInstance((io.vertx.ext.web.handler.TimeoutHandler)io.vertx.ext.web.handler.TimeoutHandler.create());
    return ret;
  }

  /**
   * @param timeout the timeout, in ms
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.TimeoutHandler create(long timeout) { 
    io.vertx.mutiny.ext.web.handler.TimeoutHandler ret = io.vertx.mutiny.ext.web.handler.TimeoutHandler.newInstance((io.vertx.ext.web.handler.TimeoutHandler)io.vertx.ext.web.handler.TimeoutHandler.create(timeout));
    return ret;
  }

  /**
   * @param timeout the timeout, in ms
   * @param errorCode 
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.TimeoutHandler create(long timeout, int errorCode) { 
    io.vertx.mutiny.ext.web.handler.TimeoutHandler ret = io.vertx.mutiny.ext.web.handler.TimeoutHandler.newInstance((io.vertx.ext.web.handler.TimeoutHandler)io.vertx.ext.web.handler.TimeoutHandler.create(timeout, errorCode));
    return ret;
  }

  /**
   * The default timeout, in ms
   */
  public static final long DEFAULT_TIMEOUT = io.vertx.ext.web.handler.TimeoutHandler.DEFAULT_TIMEOUT;
  /**
   * The default error code
   */
  public static final int DEFAULT_ERRORCODE = io.vertx.ext.web.handler.TimeoutHandler.DEFAULT_ERRORCODE;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  TimeoutHandler newInstance(io.vertx.ext.web.handler.TimeoutHandler arg) {
    return arg != null ? new TimeoutHandler(arg) : null;
  }

}
