/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniAwaitOptional;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniBlockingAwait;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromKnownFailure;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromKnownItem;
import java.time.Duration;
import java.util.concurrent.CompletionException;

public class UniAwait<T> {
    private final Uni<T> upstream;
    private final Context context;

    public UniAwait(Uni<T> upstream, Context context) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
        this.context = context;
    }

    public T indefinitely() {
        return this.atMost(null);
    }

    public T atMost(Duration duration) {
        Uni<T> uni = this.upstream;
        if (uni instanceof UniCreateFromKnownItem) {
            UniCreateFromKnownItem known = (UniCreateFromKnownItem)uni;
            return this.awaitKnownItem(known, duration);
        }
        uni = this.upstream;
        if (uni instanceof UniCreateFromKnownFailure) {
            UniCreateFromKnownFailure known = (UniCreateFromKnownFailure)uni;
            this.awaitKnownFailure(known, duration);
        }
        return UniBlockingAwait.await(this.upstream, duration, this.context);
    }

    @CheckReturnValue
    public UniAwaitOptional<T> asOptional() {
        return new UniAwaitOptional<T>(this.upstream, this.context);
    }

    private T awaitKnownItem(UniCreateFromKnownItem<T> known, Duration duration) {
        this.validateDuration(duration);
        if (!Infrastructure.canCallerThreadBeBlocked()) {
            throw UniBlockingAwait.currentThreadCannotBeBlocked();
        }
        return known.getItem();
    }

    private void awaitKnownFailure(UniCreateFromKnownFailure<T> known, Duration duration) {
        this.validateDuration(duration);
        if (!Infrastructure.canCallerThreadBeBlocked()) {
            throw UniBlockingAwait.currentThreadCannotBeBlocked();
        }
        Throwable throwable = known.getFailure();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new CompletionException(throwable);
    }

    private void validateDuration(Duration duration) {
        if (duration != null && (duration.isZero() || duration.isNegative())) {
            throw new IllegalArgumentException("`duration` must be greater than zero");
        }
    }
}

