/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOnTermination;
import io.smallrye.mutiny.operators.UniOnTerminationCall;
import io.smallrye.mutiny.tuples.Functions;
import java.util.function.Supplier;

public class UniOnTerminate<T> {
    private final Uni<T> upstream;

    public UniOnTerminate(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(Functions.TriConsumer<T, Throwable, Boolean> consumer) {
        return Infrastructure.onUniCreation(new UniOnTermination<T>(this.upstream, ParameterValidation.nonNull(consumer, "consumer")));
    }

    public Uni<T> invoke(Runnable action) {
        Runnable runnable = ParameterValidation.nonNull(action, "action");
        return Infrastructure.onUniCreation(new UniOnTermination<Object>(this.upstream, (i, f, c) -> runnable.run()));
    }

    public Uni<T> call(Functions.Function3<? super T, Throwable, Boolean, Uni<?>> mapper) {
        return Infrastructure.onUniCreation(new UniOnTerminationCall<T>(this.upstream, ParameterValidation.nonNull(mapper, "mapper")));
    }

    public Uni<T> call(Supplier<Uni<?>> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.call((? super T i, Throwable f, Boolean c) -> (Uni)supplier.get());
    }

    @Deprecated
    public Uni<T> invokeUni(Functions.Function3<? super T, Throwable, Boolean, Uni<?>> mapper) {
        return this.call(mapper);
    }

    @Deprecated
    public Uni<T> invokeUni(Supplier<Uni<?>> supplier) {
        return this.call(supplier);
    }
}

