/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.MultiCollector;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MultiCollect<T> {
    private final Multi<T> upstream;

    public MultiCollect(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> first() {
        return MultiCollector.first(this.upstream);
    }

    public Uni<T> last() {
        return MultiCollector.last(this.upstream);
    }

    public Uni<List<T>> asList() {
        return MultiCollector.list(this.upstream);
    }

    public <X, A> Uni<X> with(Collector<? super T, A, ? extends X> collector) {
        return MultiCollector.collector(this.upstream, collector, true);
    }

    public <X> Uni<X> in(Supplier<X> supplier, BiConsumer<X, T> accumulator) {
        return MultiCollector.collectInto(this.upstream, supplier, accumulator);
    }

    public <K> Uni<Map<K, T>> asMap(Function<? super T, ? extends K> keyMapper) {
        return this.asMap(keyMapper, Function.identity());
    }

    public <K, V> Uni<Map<K, V>> asMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return MultiCollector.map(this.upstream, keyMapper, valueMapper);
    }

    public <K, V> Uni<Map<K, Collection<V>>> asMultiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return MultiCollector.multimap(this.upstream, keyMapper, valueMapper);
    }

    public <K> Uni<Map<K, Collection<T>>> asMultiMap(Function<? super T, ? extends K> keyMapper) {
        return MultiCollector.multimap(this.upstream, keyMapper, Function.identity());
    }
}

