/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class UniSerializedSubscriber<T>
implements UniSubscriber<T>,
UniSubscription {
    private static final int INIT = 0;
    private static final int SUBSCRIBED = 1;
    private static final int HAS_SUBSCRIPTION = 2;
    private static final int DONE = 3;
    private final AtomicInteger state = new AtomicInteger(0);
    private final AbstractUni<T> source;
    private final UniSubscriber<? super T> downstream;
    private UniSubscription upstream;
    private AtomicReference<Throwable> collectedFailure = new AtomicReference();

    private UniSerializedSubscriber(AbstractUni<T> source, UniSubscriber<? super T> subscriber) {
        this.source = ParameterValidation.nonNull(source, "source");
        this.downstream = ParameterValidation.nonNull(subscriber, "subscriber` must not be `null`");
    }

    public static <T> void subscribe(AbstractUni<T> source, UniSubscriber<? super T> subscriber) {
        UniSubscriber<? super T> actual = Infrastructure.onUniSubscription(source, subscriber);
        UniSerializedSubscriber<? super T> wrapped = new UniSerializedSubscriber<T>(source, actual);
        super.subscribe();
    }

    private void subscribe() {
        if (this.state.compareAndSet(0, 1)) {
            this.source.subscribing(this);
        } else {
            EmptyUniSubscription.propagateFailureEvent(this.downstream, new IllegalStateException("Unable to subscribe, already got a subscriber"));
        }
    }

    @Override
    public void onSubscribe(UniSubscription subscription) {
        ParameterValidation.nonNull(subscription, "subscription");
        if (this.state.compareAndSet(1, 2)) {
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        } else if (this.state.get() == 3) {
            Throwable collected = this.collectedFailure.getAndSet(null);
            if (collected != null) {
                this.downstream.onFailure(collected);
            }
        } else {
            EmptyUniSubscription.propagateFailureEvent(this.downstream, new IllegalStateException("Invalid transition, expected to be in the SUBSCRIBED state but was in " + this.state.get()));
        }
    }

    @Override
    public void onItem(T item) {
        if (this.state.compareAndSet(2, 3)) {
            this.downstream.onItem(item);
            this.dispose();
        } else if (this.state.get() != 3) {
            EmptyUniSubscription.propagateFailureEvent(this.downstream, new IllegalStateException("Invalid transition, expected to be in the HAS_SUBSCRIPTION state but was in " + this.state.get()));
        }
    }

    @Override
    public void onFailure(Throwable failure) {
        if (this.state.compareAndSet(2, 3)) {
            this.downstream.onFailure(failure);
        } else if (this.state.compareAndSet(1, 3)) {
            this.collectedFailure.compareAndSet(null, failure);
        } else if (this.state.get() != 3) {
            EmptyUniSubscription.propagateFailureEvent(this.downstream, new IllegalStateException("Invalid transition, expected to be in the HAS_SUBSCRIPTION state but was in " + this.state.get()));
        }
    }

    private void dispose() {
        this.upstream = null;
    }

    @Override
    public void cancel() {
        if (this.state.compareAndSet(2, 3)) {
            this.upstream.cancel();
            this.dispose();
        }
    }

    public boolean isCancelledOrDone() {
        return this.state.get() == 3;
    }
}

